/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.version;

import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.version.AgentVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControllerVersion {
    private static final String RELUCTANT_WILDCARD = ".*?";
    private static final String VERSION_SEGMENT = "[0-9]+";
    private static final String VERSION_DELIMITER = "[.-]";
    private static final String GREEDY_WILDCARD = ".*";
    private static final String ONE_OR_NONE_QUALIFIER = "?";
    private static final String VERSION_REGEX = ".*?([0-9]+)[.-]([0-9]+)[.-]([0-9]+)([.-][0-9]+)?.*";
    private static final Pattern CONTROLLER_VER_PATTERN = Pattern.compile(".*?([0-9]+)[.-]([0-9]+)[.-]([0-9]+)([.-][0-9]+)?.*");
    int major = 0;
    int minor = 0;
    int patch = 0;
    int hotfix = 0;
    Size size = Size.SMALL;

    public ControllerVersion(String controllerVersion, String controllerSize) {
        this.setVersionSegments(controllerVersion);
        this.setControllerSize(controllerSize);
    }

    private void setVersionSegments(String controllerVersion) {
        if (StringOperations.isEmpty(controllerVersion)) {
            return;
        }
        Matcher matcher = CONTROLLER_VER_PATTERN.matcher(controllerVersion);
        if (!matcher.matches()) {
            return;
        }
        this.major = this.getVersionSegment(matcher.group(1));
        this.minor = this.getVersionSegment(matcher.group(2));
        this.patch = this.getVersionSegment(matcher.group(3));
        String hotfixString = matcher.group(4);
        if (hotfixString != null && hotfixString.length() > 1) {
            this.hotfix = this.getVersionSegment(hotfixString.substring(1));
        }
    }

    private void setControllerSize(String controllerSize) {
        if (controllerSize == null) {
            return;
        }
        this.size = (controllerSize = controllerSize.toLowerCase()).contains("medium") ? Size.MEDIUM : (controllerSize.contains("large") ? Size.LARGE : (controllerSize.contains("huge") ? Size.HUGE : Size.SMALL));
    }

    public int getVersionSegment(String version) {
        if (StringOperations.isEmpty(version)) {
            return 0;
        }
        return Integer.parseInt(version);
    }

    public ControllerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean isGreaterThanEquals(ControllerVersion otherVersion) {
        return this.major > otherVersion.major || this.major == otherVersion.major && this.minor > otherVersion.minor || this.major == otherVersion.major && this.minor == otherVersion.minor && this.patch >= otherVersion.patch;
    }

    public boolean isEquals(ControllerVersion otherVersion) {
        return this.major == otherVersion.major && this.minor == otherVersion.minor && this.patch == otherVersion.patch;
    }

    public boolean isCompatibleWithAgentVersion(String version) {
        AgentVersion matcher = new AgentVersion(version);
        return this.isCompatibleWithAgentVersion(matcher);
    }

    public boolean isCompatibleWithAgentVersion(AgentVersion matcher) {
        return this.major > matcher.getMajorRelease() || this.major == matcher.getMajorRelease() && this.minor >= matcher.getMinorRelease();
    }

    public Size getSize() {
        return this.size;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static enum Size {
        HUGE,
        LARGE,
        MEDIUM,
        SMALL;

    }
}

