/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.system;

import com.singularity.ee.util.logging.ILogger;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SystemUtils {
    static final Map<String, String> readOnlyCachedSystemProperties = new HashMap<String, String>();
    private static String jvmPID;

    private SystemUtils() {
    }

    public static String getCachedProperty(String propertyName) {
        return readOnlyCachedSystemProperties.get(propertyName);
    }

    public static Properties getSystemProperties() {
        return System.getProperties();
    }

    public static String getProperty(String propName) {
        return System.getProperty(propName);
    }

    public static String getProperty(String propName, String def) {
        return System.getProperty(propName, def);
    }

    public static String getenv(String envVariableName) {
        return System.getenv(envVariableName);
    }

    public static void setProperty(String propName, String propValue) {
        System.setProperty(propName, propValue);
    }

    public static String getVMPID(ILogger logger) {
        if (jvmPID != null) {
            return jvmPID;
        }
        try {
            String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
            logger.info("JVM Runtime Name: " + runtimeName);
            if (runtimeName == null) {
                return null;
            }
            String[] splits = runtimeName.split("@");
            if (splits == null || splits.length == 0) {
                return null;
            }
            String pid = splits[0];
            try {
                Integer.parseInt(pid);
                logger.info("JVM PID: " + pid);
                jvmPID = pid;
            }
            catch (NumberFormatException nfe) {
                jvmPID = null;
                logger.warn("Exception while trying to parse jvm pid " + nfe);
            }
        }
        catch (Throwable t) {
            logger.warn("Error while trying to get JVM PID " + t);
        }
        return jvmPID;
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static void writeCurrentCallStackToLog(String header, ILogger logger) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null) {
            logger.info(header);
            for (StackTraceElement element : stackTrace) {
                logger.info(element.toString());
            }
            logger.info("End of stack trace");
        }
    }

    public static String getProperty(String envVariableName, String sysPropertyKey, String propertyName, ILogger logger) {
        block6: {
            try {
                String envVarValue = SystemUtils.getenv(envVariableName);
                if (envVarValue != null) {
                    if (logger != null && logger.isInfoEnabled()) {
                        logger.info(" found env variable [" + envVariableName + "] for " + propertyName + " [" + envVarValue + "]");
                    }
                    return envVarValue;
                }
                String sysPropValue = SystemUtils.getProperty(sysPropertyKey);
                if (sysPropValue != null) {
                    if (logger != null && logger.isInfoEnabled()) {
                        logger.info(" found system property [" + sysPropertyKey + "] for " + propertyName + " [" + sysPropValue + "]");
                    }
                    return sysPropValue;
                }
            }
            catch (Exception e) {
                if (logger == null) break block6;
                logger.warn("Error in reading environment variable/system property ", e);
            }
        }
        return null;
    }

    static {
        for (Object key : System.getProperties().keySet()) {
            String stringKey = (String)key;
            readOnlyCachedSystemProperties.put(stringKey, System.getProperty(stringKey));
        }
        jvmPID = null;
    }
}

