/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.string;

import java.util.Set;
import java.util.regex.Pattern;

public class StringRegexOperations {
    private static final Pattern jRubyJITPrefix = Pattern.compile("ruby.jit.");
    private static final String specialCharactersRegex = "[^A-Za-z0-9-_]";

    public static Pattern compilePattern(Set<String> packagePrefixes, boolean includePrimitives) {
        StringBuilder regex = new StringBuilder();
        if (includePrimitives) {
            regex.append("((\\[)*[BCDFIJSZ])");
        }
        for (String s : packagePrefixes) {
            regex.append("|");
            regex.append("((\\[)*L?" + Pattern.quote(s) + "(.)*)");
        }
        return Pattern.compile(regex.toString());
    }

    public static String[] splitKeyValue(String str, char delimiter) {
        int index = str.indexOf(delimiter);
        if (index == -1) {
            return new String[]{str};
        }
        String[] result = new String[]{str.substring(0, index), str.substring(index + 1, str.length())};
        return result;
    }

    public static String[] split(String str, String regex) {
        return str.split(regex);
    }

    public static String[] split(String str, String regex, int limit) {
        return str.split(regex, limit);
    }

    static String[] jRubyRegexSplit(String traceElementClassName) {
        return jRubyJITPrefix.split(traceElementClassName);
    }

    public static boolean regexFind(Pattern regexPattern, String inputString) {
        return regexPattern.matcher(inputString).find();
    }

    public static boolean endsWith(String uri, String extn, boolean ignoreCase) {
        return uri.endsWith(extn);
    }

    public static boolean startsWith(String uri, String ignoreURI, boolean ignoreCase) {
        return uri.startsWith(ignoreURI);
    }

    public static String replaceAll(String input, String regex, String replacement) {
        return input.replaceAll(regex, replacement);
    }

    public static String removeAllSpecialCharacters(String str) {
        if (str != null) {
            return StringRegexOperations.replaceAll(str, specialCharactersRegex, "");
        }
        return str;
    }
}

