/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.string;

import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.string.EncoderHelper;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MapEncoder {
    public static final char MAP_ENTRY_DELIMITER = '|';
    private static final String MAP_ENTRY_DELIMITER_REGEX = "\\|";
    public static final char NAME_VALUE_DELIMITER = '=';

    private MapEncoder() {
    }

    public static String mapToString(Map<String, String> input) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        for (String name : input.keySet()) {
            if (name == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            String value = input.get(name);
            if (value == null) {
                throw new IllegalArgumentException("null values are not allowed");
            }
            EncoderHelper.assertElementDoesNotContainDelimiter(name, '|');
            EncoderHelper.assertElementDoesNotContainDelimiter(value, '|');
            EncoderHelper.assertElementDoesNotContainDelimiter(name, '=');
            EncoderHelper.assertElementDoesNotContainDelimiter(value, '=');
            if (!isStart) {
                builder.append('|');
            }
            builder.append(name).append('=').append(value);
            isStart = false;
        }
        return builder.toString();
    }

    public static Map<String, String> stringToMap(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return CollectionHelper.emptySerializableMap();
        }
        if (input.indexOf(61) == -1) {
            throw new IllegalArgumentException("input string is not encoded correctly [" + input + "]");
        }
        return MapEncoder.parseNameValuePairs(input);
    }

    public static Map<String, String> parseNameValuePairs(String input) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] nameValuePairs = StringRegexOperations.split(input, MAP_ENTRY_DELIMITER_REGEX);
        Pattern pattern = Pattern.compile(String.valueOf('='));
        for (String nameValuePair : nameValuePairs) {
            String[] nameAndValue = pattern.split(nameValuePair);
            if (nameAndValue.length != 2) {
                throw new IllegalArgumentException("input string is not encoded correctly [" + input + "]");
            }
            String name = nameAndValue[0];
            String value = nameAndValue[1];
            if (map.put(name, value) == null) continue;
            throw new IllegalArgumentException("detected multiple values mapped to same key in input string [" + input + "]");
        }
        return map;
    }
}

