/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.string;

import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.string.EncoderHelper;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.Collection;
import java.util.List;

public class ArrayEncoder {
    public static final char DELIMITER = '|';
    public static final String DELIMITER_REGEX = "\\|";
    private static final int[] EMPTY_INTEGER_ARRAY = new int[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private ArrayEncoder() {
    }

    public static String integerArrayToString(int[] input) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (i > 0) {
                builder.append('|');
            }
            builder.append(input[i]);
        }
        return builder.toString();
    }

    public static int[] stringToIntegerArray(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return EMPTY_INTEGER_ARRAY;
        }
        String[] strings = StringRegexOperations.split(input, DELIMITER_REGEX);
        int[] integers = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                integers[i] = Integer.parseInt(strings[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("input [" + input + "] cannot be decoded into an integer array because of element [" + strings[i] + "]");
            }
        }
        return integers;
    }

    @Deprecated
    public static String stringArrayToString(String ... input) {
        return ArrayEncoder.stringArrayToString(input, '|');
    }

    @Deprecated
    public static String safeStringArrayToString(String ... input) {
        String str = ArrayEncoder.stringArrayToString(input, '|');
        return str == null ? "" : str;
    }

    public static String safeStringArrayToString(Collection<String> input) {
        String str = ArrayEncoder.stringArrayToString(input, '|');
        return str == null ? "" : str;
    }

    public static String safeStringArrayToString(Collection<String> input, char delimiter) {
        String str = ArrayEncoder.stringArrayToString(input, delimiter);
        return str == null ? "" : str;
    }

    public static String stringArrayToString(String[] input, char delimiter) {
        if (input == null) {
            return null;
        }
        return ArrayEncoder.stringArrayToString(CollectionHelper.asList(input), delimiter);
    }

    public static String stringArrayToString(Collection<String> input, char delimiter) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        for (String ele : input) {
            EncoderHelper.assertElementDoesNotContainDelimiter(ele, delimiter);
            if (!isStart) {
                builder.append(delimiter);
            }
            builder.append(ele);
            isStart = false;
        }
        return builder.toString();
    }

    public static String stringArrayToString(List<String> input, int start, int end, char delimiter) {
        if (input == null) {
            return null;
        }
        if (start > end) {
            throw new IllegalArgumentException("start should be lesser than end start [" + start + "] end [" + end + "]");
        }
        if (end >= input.size()) {
            throw new IllegalArgumentException("end index should not be >= the size. end [" + end + "] size [" + input.size() + "]");
        }
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        for (int i = start; i <= end; ++i) {
            String ele = input.get(i);
            EncoderHelper.assertElementDoesNotContainDelimiter(ele, delimiter);
            if (!isStart) {
                builder.append(delimiter);
            }
            builder.append(ele);
            isStart = false;
        }
        return builder.toString();
    }

    public static String[] stringToStringArray(String input) {
        return ArrayEncoder.stringToStringArray(input, DELIMITER_REGEX);
    }

    public static String[] stringToStringArray(String input, String[] defaultStringArray) {
        String[] results = ArrayEncoder.stringToStringArray(input, DELIMITER_REGEX);
        if (results == null) {
            return defaultStringArray;
        }
        return results;
    }

    public static String[] stringToStringArray(String input, String delimiter) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return StringRegexOperations.split(input, delimiter);
    }

    public static String[] safeStringToStringArray(String input) {
        String[] strArr = ArrayEncoder.stringToStringArray(input);
        return strArr == null ? EMPTY_STRING_ARRAY : strArr;
    }

    public static String[] safeStringToStringArray(String input, char delimiter) {
        String[] array = ArrayEncoder.stringToStringArray(input, delimiter + "");
        return array == null ? EMPTY_STRING_ARRAY : array;
    }

    public static String longArrayToString(Collection<Long> input, char delimiter) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isStart = true;
        for (Long ele : input) {
            if (!isStart) {
                builder.append(delimiter);
            }
            builder.append(ele);
            isStart = false;
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        String[] strs = new String[]{"", ""};
        String str = ArrayEncoder.stringArrayToString(strs);
        System.out.println(str);
        System.out.println(ArrayEncoder.stringToStringArray(str).length);
    }
}

