/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.reflect;

import com.singularity.ee.util.collections.HashCodeUtil;
import java.util.List;

public class MethodCacheEntry {
    private String methodName;
    private List<String> params;

    public MethodCacheEntry(String methodName, List<String> params) {
        this.methodName = methodName;
        this.params = params;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getParams() {
        return this.params;
    }

    public int hashCode() {
        return HashCodeUtil.calculateHashCode(this.methodName, this.params);
    }

    public boolean equals(Object o) {
        if (o instanceof MethodCacheEntry) {
            MethodCacheEntry other = (MethodCacheEntry)o;
            if (!this.methodName.equals(other.getMethodName())) {
                return false;
            }
            return this.params.equals(other.getParams());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Method Name [").append(this.methodName).append("]");
        sb.append("\nParams [").append(this.params).append("]");
        return sb.toString();
    }
}

