/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.poller;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;

public abstract class Poller {
    protected abstract boolean run();

    public boolean poll(int minutes) {
        return this.poll(minutes, 10000L, null, null);
    }

    public boolean poll(int minutes, ILogger logger, String failMsg) {
        return this.poll(minutes, 10000L, logger, failMsg);
    }

    public boolean fastPoll(long timeToRunInMillis, long intervalInMillis) {
        return this.fastPoll(timeToRunInMillis, intervalInMillis, null, null);
    }

    public boolean fastPoll(long timeToRunInMillis, ILogger logger, String failMsg) {
        return this.fastPoll(timeToRunInMillis, 10000L, logger, failMsg);
    }

    public boolean poll(int minutes, long interval) {
        return this.poll(minutes, interval, null, null);
    }

    public boolean poll(int minutes, long interval, ILogger logger, String failMsg) {
        return this.fastPoll(minutes * 60000, interval, logger, failMsg);
    }

    private boolean fastPoll(long timeToRunInMillis, long intervalInMillis, ILogger logger, String failMsg) {
        long endTime = System.currentTimeMillis() + timeToRunInMillis;
        do {
            if (this.run()) {
                return true;
            }
            try {
                Thread.sleep(intervalInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() <= endTime);
        if (logger != null) {
            logger.error(StringOperations.isEmpty(failMsg) ? "Task failed" : failMsg);
        }
        return false;
    }
}

