/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.logging;

import com.singularity.ee.util.logging.ILogger;
import java.io.PrintStream;
import java.util.Date;

public class SysOutLogger
implements ILogger {
    private final String category;
    private final PrintStream printStream;
    private boolean debugEnabled;
    private boolean infoEnabled;
    private boolean traceEnabled;

    public SysOutLogger(String category) {
        this(category, System.out);
    }

    public SysOutLogger(String category, PrintStream printStream) {
        this.category = category;
        this.printStream = printStream;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    @Override
    public void debug(String msg) {
        this.print("DEBUG", msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.print("DEBUG", msg, t);
    }

    @Override
    public void error(String msg) {
        this.print("ERROR", msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.print("ERROR", msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.print("FATAL", msg);
    }

    @Override
    public void fatal(String msg, Throwable t) {
        this.print("FATAL", msg, t);
    }

    @Override
    public void info(String msg) {
        this.print("INFO", msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.print("INFO", msg, t);
    }

    @Override
    public void trace(String msg) {
        this.print("TRACE", msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.print("TRACE", msg, t);
    }

    @Override
    public void warn(String msg) {
        this.print("WARN", msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.print("WARN", msg, t);
    }

    private void print(String context, String message) {
        this.printStream.println(this.logPrefix() + "[" + context + "]: " + this.category + " - " + message);
    }

    private String logPrefix() {
        return "[" + Thread.currentThread().getName() + "] " + new Date();
    }

    private void print(String context, String message, Throwable t) {
        this.printStream.println(this.logPrefix() + "[" + context + "]: " + this.category + " - " + message + "Exception " + t);
        t.printStackTrace(this.printStream);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }
}

