/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.logcapture;

import com.singularity.ee.util.compress.CompressedObject;
import com.singularity.ee.util.compress.CompressionUtility;
import com.singularity.ee.util.logcapture.LogFileDelta;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFileMonitor {
    public static final int CONSECUTIVE_CATCHUP_ATTEMPTS = 5;
    public static final byte[] NEW_LINE_BYTES = "\n".getBytes();
    private int catchupAttemptIndex;
    private int deltaCapInBytes;
    private int compressionLimit;
    private long currentFilePointer;
    private RandomAccessFile monitoredLogFile;
    private Pattern filterPattern;
    private String monitoredLogFilePath;

    public LogFileMonitor(String monitoredLogFilePath, String filterExpression, int compressionLimit, int deltaCap) throws IOException {
        this.monitoredLogFilePath = monitoredLogFilePath;
        this.monitoredLogFile = new RandomAccessFile(new File(monitoredLogFilePath), "r");
        this.currentFilePointer = this.monitoredLogFile.length();
        this.monitoredLogFile.seek(this.currentFilePointer);
        if (filterExpression != null && !filterExpression.equals("")) {
            this.filterPattern = Pattern.compile(filterExpression);
        }
        this.compressionLimit = compressionLimit;
        this.deltaCapInBytes = deltaCap;
    }

    public void setFileDeltaCap(int bytes) {
        this.deltaCapInBytes = bytes;
    }

    public LogFileDelta getCurrentLogDelta() throws IOException {
        this.monitoredLogFile = new RandomAccessFile(new File(this.monitoredLogFilePath), "r");
        this.validateCurrentLengthAndSeek();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.monitoredLogFile.length() != this.currentFilePointer) {
            String lineRead = "";
            while (lineRead != null) {
                lineRead = this.monitoredLogFile.readLine();
                this.addLineIfMatchesExpression(lineRead, baos);
                if (baos.size() <= this.deltaCapInBytes) continue;
            }
            this.currentFilePointer = this.monitoredLogFile.getFilePointer();
        }
        return this.createLogDelta(baos);
    }

    private void validateCurrentLengthAndSeek() throws IOException {
        if (this.currentFilePointer > this.monitoredLogFile.length()) {
            this.currentFilePointer = 0L;
        }
        this.monitoredLogFile.seek(this.currentFilePointer);
    }

    private LogFileDelta createLogDelta(ByteArrayOutputStream baos) throws IOException {
        boolean truncated = false;
        if (baos.size() > this.deltaCapInBytes) {
            truncated = true;
            byte[] truncatedMessage = ("TRUNCATED AFTER " + this.deltaCapInBytes / 1024 + "KB..............................\n").getBytes();
            baos.write(truncatedMessage);
            ++this.catchupAttemptIndex;
            if (this.catchupAttemptIndex == 5) {
                this.catchupAttemptIndex = 0;
                byte[] truncatedCatchupMessage = "DATA TRUNCATED 5 TIMES SUCCESSIVELY, MOVING TO THE END OF THE FILE.\n".getBytes();
                baos.write(truncatedCatchupMessage);
                this.currentFilePointer = this.monitoredLogFile.length();
            }
        }
        String deltaString = new String(baos.toByteArray());
        if (baos.size() > this.compressionLimit) {
            CompressedObject compressedString = CompressionUtility.compressString(deltaString);
            return new LogFileDelta(compressedString, truncated);
        }
        return new LogFileDelta(deltaString, truncated);
    }

    private void addLineIfMatchesExpression(String lineRead, ByteArrayOutputStream baos) throws IOException {
        if (lineRead != null) {
            if (this.filterPattern != null) {
                Matcher successMatcher = this.filterPattern.matcher(lineRead);
                if (successMatcher.find()) {
                    baos.write(lineRead.getBytes());
                    baos.write(NEW_LINE_BYTES);
                }
            } else {
                baos.write(lineRead.getBytes());
                baos.write(NEW_LINE_BYTES);
            }
        }
    }
}

