/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.logcapture;

import com.singularity.ee.util.compress.CompressedObject;

public class LogFileDelta {
    private String logData;
    private boolean isCompressed;
    private boolean isTruncated;
    private int originalLength;
    private int compressedLength;

    public LogFileDelta(String logData, boolean isTruncated) {
        this.logData = logData;
        this.isCompressed = false;
        this.originalLength = logData.length();
        this.compressedLength = -1;
        this.isTruncated = isTruncated;
    }

    public LogFileDelta(CompressedObject compressedString, boolean isTruncated) {
        this.logData = new String(compressedString.getCompressedBytes());
        this.isCompressed = true;
        this.originalLength = compressedString.getOriginalLength();
        this.compressedLength = compressedString.getCompressedLength();
        this.isTruncated = isTruncated;
    }

    public String getLogData() {
        return this.logData;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean truncated) {
        this.isTruncated = truncated;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    public int getCompressedLength() {
        return this.compressedLength;
    }
}

