/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.logcapture;

import com.singularity.ee.util.logcapture.LogCompressorConstants;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogCompressor
implements LogCompressorConstants {
    private ILogger logger;
    private String zipFilePath;
    private StringBuilder fileStats;
    private boolean fileContentsTruncated = false;
    private DescendingComparator comparator = new DescendingComparator();
    private byte[] buffer;
    private ZipOutputStream zipOut;

    public LogCompressor(String zipFilePath, StringBuilder fileStats, ILogger logger) {
        this.zipFilePath = zipFilePath;
        this.fileStats = fileStats;
        this.logger = logger;
        this.initialize();
    }

    public String getZipFilePath() {
        return this.zipFilePath;
    }

    public StringBuilder getFileStats() {
        return this.fileStats;
    }

    public boolean isFileContentsTruncated() {
        return this.fileContentsTruncated;
    }

    private void initialize() {
        try {
            this.buffer = new byte[8192];
            this.zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipFilePath)));
        }
        catch (Throwable t) {
            this.logger.error("Error occurred in attempting to initialize log compressor.", t);
        }
    }

    public List<String> archiveFiles(List<String> filePathList) {
        if (filePathList == null || filePathList.isEmpty()) {
            return null;
        }
        String[] filePathArray = filePathList.toArray(new String[filePathList.size()]);
        return this.archiveFiles(filePathArray, 0x500000);
    }

    public List<String> archiveFiles(String[] filePathArray, int threshold) {
        if (filePathArray == null || filePathArray.length == 0) {
            return null;
        }
        ArrayList<String> fileWhichDNEList = null;
        TreeMap<String, File> fileVsZipEntryName = new TreeMap<String, File>();
        LinkedHashSet<String> zipEntryFileNameSet = new LinkedHashSet<String>();
        for (String filePath : filePathArray) {
            if (filePath == null) continue;
            File file = new File(filePath);
            if (!file.exists()) {
                if (fileWhichDNEList == null) {
                    fileWhichDNEList = new ArrayList<String>();
                }
                fileWhichDNEList.add(filePath);
                continue;
            }
            String zipEntryFileName = file.getName();
            for (int suffix = 0; suffix < 100 && zipEntryFileNameSet.contains(zipEntryFileName); ++suffix) {
                zipEntryFileName = zipEntryFileName + "-" + suffix;
            }
            fileVsZipEntryName.put(zipEntryFileName, file);
            zipEntryFileNameSet.add(zipEntryFileName);
        }
        this.processFileMap(threshold, 0L, fileVsZipEntryName);
        return fileWhichDNEList;
    }

    public void archiveFiles(Map<File, String> fileVsZipEntryName) {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            for (Map.Entry<File, String> entry : fileVsZipEntryName.entrySet()) {
                int count;
                File file = entry.getKey();
                String zipName = entry.getValue();
                String fileName = file.getName();
                this.fileStats.append(String.format("Compressed File : %s size[%d] bytes", fileName, file.length()));
                this.fileStats.append(LINE_SEP);
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                ZipEntry zipEntry = new ZipEntry(zipName);
                this.zipOut.putNextEntry(zipEntry);
                while ((count = bufferedInputStream.read(this.buffer, 0, 8192)) != -1) {
                    this.zipOut.write(this.buffer, 0, count);
                }
                this.zipOut.flush();
                this.zipOut.closeEntry();
                this.closeQuietly(fileInputStream);
                this.closeQuietly(bufferedInputStream);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (bufferedInputStream != null) {
                this.closeQuietly(bufferedInputStream);
            }
            if (fileInputStream != null) {
                this.closeQuietly(fileInputStream);
            }
        }
    }

    private void closeQuietly(Closeable closeable) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Error closing - ", e);
            }
        }
    }

    public void archiveFilesByEmbeddedFileNameDate(File[] fileArray, int threshold, String logFileType) {
        if (fileArray != null && fileArray.length > 0) {
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.fileStats.append(logFileType).append(" log fileArray").append(LINE_SEP);
            this.fileStats.append("Found Files : ").append(fileArray.length).append(LINE_SEP);
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            TreeMap<String, TreeMap<String, File>> fileMap = new TreeMap<String, TreeMap<String, File>>(this.comparator);
            for (File file : fileArray) {
                this.addToFileMap(file, fileMap, file.getName(), logFileType);
            }
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.writeFileSet(fileMap, threshold);
        } else {
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.fileStats.append(logFileType).append(LINE_SEP);
            this.fileStats.append("Found Files : ").append("0").append(LINE_SEP);
            this.fileStats.append("==================================================================================").append(LINE_SEP);
        }
    }

    public void archiveFilesByLastModifiedDate(File[] fileArray, int threshold, String logFileType, SimpleDateFormat format) {
        if (fileArray != null && fileArray.length > 0) {
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.fileStats.append(logFileType).append(" log fileArray").append(LINE_SEP);
            this.fileStats.append("Found Files : ").append(fileArray.length).append(LINE_SEP);
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            TreeMap<String, TreeMap<String, File>> fileMap = new TreeMap<String, TreeMap<String, File>>(this.comparator);
            for (File file : fileArray) {
                this.addToFileMap(file, fileMap, format);
            }
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.writeFileSet(fileMap, threshold);
        } else {
            this.fileStats.append("==================================================================================").append(LINE_SEP);
            this.fileStats.append(logFileType).append(LINE_SEP);
            this.fileStats.append("Found Files : ").append("0").append(LINE_SEP);
            this.fileStats.append("==================================================================================").append(LINE_SEP);
        }
    }

    private void addToFileMap(File file, Map<String, TreeMap<String, File>> dateVsFileNameVsFile, String name, String logFileType) {
        int index = name.indexOf(".", logFileType.length() + 1);
        if (index == -1) {
            return;
        }
        String dateTime = name.substring(logFileType.length() + 1, index);
        TreeMap<String, File> fileNameVsFile = dateVsFileNameVsFile.get(dateTime);
        if (fileNameVsFile == null) {
            fileNameVsFile = new TreeMap(this.comparator);
            dateVsFileNameVsFile.put(dateTime, fileNameVsFile);
        }
        fileNameVsFile.put(file.getName(), file);
    }

    private void addToFileMap(File file, Map<String, TreeMap<String, File>> dateVsFileNameVsFile, SimpleDateFormat format) {
        Date date = new Date(file.lastModified());
        String formattedDate = format.format(date);
        TreeMap<String, File> fileNameVsFile = dateVsFileNameVsFile.get(formattedDate);
        if (fileNameVsFile == null) {
            fileNameVsFile = new TreeMap();
            dateVsFileNameVsFile.put(formattedDate, fileNameVsFile);
        }
        fileNameVsFile.put(file.getName(), file);
    }

    private void writeFileSet(Map<String, TreeMap<String, File>> fileMap, int threshold) {
        long runningSize = 0L;
        for (String formattedDate : fileMap.keySet()) {
            TreeMap<String, File> fileNameVsFile = fileMap.get(formattedDate);
            runningSize = this.processFileMap(threshold, runningSize, fileNameVsFile);
        }
        this.fileStats.append("==================================================================================").append(LINE_SEP);
    }

    private long processFileMap(int threshold, long runningSize, TreeMap<String, File> fileNameVsFile) {
        if (fileNameVsFile.isEmpty()) {
            return runningSize;
        }
        String lastKey = fileNameVsFile.lastKey();
        File file = fileNameVsFile.remove(lastKey);
        String zipEntryFileName = lastKey;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        RandomAccessFile raf = null;
        Iterator<String> fileNameIterator = fileNameVsFile.keySet().iterator();
        do {
            try {
                if (runningSize + file.length() <= (long)threshold) {
                    int count;
                    runningSize += file.length();
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis, 8192);
                    ZipEntry entry = new ZipEntry(file.getName());
                    this.zipOut.putNextEntry(entry);
                    while ((count = bis.read(this.buffer, 0, 8192)) != -1) {
                        this.zipOut.write(this.buffer, 0, count);
                    }
                    this.zipOut.flush();
                    this.zipOut.closeEntry();
                    this.fileStats.append(String.format("Compressed File : %s size [%d] bytes", file.getName(), file.length()));
                    this.fileStats.append(LINE_SEP);
                } else {
                    this.fileContentsTruncated = true;
                    long delta = (long)threshold - runningSize;
                    if (delta > 0L) {
                        int count;
                        runningSize += delta;
                        raf = new RandomAccessFile(file, "r");
                        raf.seek(raf.length() - delta);
                        ZipEntry entry = new ZipEntry(zipEntryFileName);
                        this.zipOut.putNextEntry(entry);
                        StringBuilder truncatedFileMsg = new StringBuilder();
                        truncatedFileMsg.append(String.format("This file has been truncated. Only the tail [%d] bytes of the file is included. The actual file size is [%d] bytes.", delta, raf.length()));
                        this.zipOut.write(truncatedFileMsg.toString().getBytes());
                        this.zipOut.write(LINE_SEP.getBytes());
                        this.zipOut.write("==================================================================================".getBytes());
                        this.zipOut.write(LINE_SEP.getBytes());
                        this.zipOut.flush();
                        while ((count = raf.read(this.buffer, 0, 8192)) != -1) {
                            this.zipOut.write(this.buffer, 0, count);
                        }
                        this.zipOut.flush();
                        this.zipOut.closeEntry();
                        this.fileStats.append(String.format("Partial File : %s size [%d] bytes.", file.getName(), file.length()));
                        this.fileStats.append(LINE_SEP);
                    } else {
                        this.fileStats.append("Not included File : ").append(file.getName()).append(LINE_SEP);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                        bis = null;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error closing buffered input stream.", e);
                }
                try {
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error closing file input stream.", e);
                }
                try {
                    if (raf != null) {
                        raf.close();
                        raf = null;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error closing random access file.", e);
                }
            }
            if (fileNameIterator.hasNext()) {
                zipEntryFileName = fileNameIterator.next();
                file = fileNameVsFile.get(zipEntryFileName);
                continue;
            }
            file = null;
        } while (file != null);
        return runningSize;
    }

    public void includeFileStatsAndFinalizeArchive() {
        ZipEntry fileStatEntry = new ZipEntry("FileStats.log");
        try {
            this.zipOut.putNextEntry(fileStatEntry);
            this.zipOut.write(this.fileStats.toString().getBytes());
            this.zipOut.write(LINE_SEP.getBytes());
            this.zipOut.write("==================================================================================".getBytes());
            this.zipOut.write(LINE_SEP.getBytes());
            this.zipOut.flush();
            this.zipOut.finish();
            this.zipOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class DescendingComparator
    implements Comparator<String> {
        private DescendingComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    }
}

