/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.loader;

import com.singularity.ee.util.io.PathResolver;
import com.singularity.ee.util.loader.ArchiveResourceFinder;
import com.singularity.ee.util.loader.DirResourceFinder;
import com.singularity.ee.util.loader.IResourceFinder;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class FileSystemClassLoader
extends ClassLoader {
    private static final Enumeration<URL> EMPTY_ENUM = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    };
    private ILogger logger;
    private String extensionDirPath;
    private String classLoaderContext = "";
    private final Collection<IResourceFinder> resourceFinders = Collections.synchronizedCollection(new ArrayList());
    private boolean ignoreSecurityExceptionOnDefinePackage;
    static final String PROPERTY_CLASS_PATH_SEPARATOR_AUTO_PARSE_ENABLED = "appdynamics.classPathSeparator.autoParse.enabled";
    private final boolean postDelegating;

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getResources called:" + name);
        }
        if (!this.postDelegating) {
            resources = this.getParent().getResources(name);
            if (resources != null && resources.hasMoreElements()) {
                return resources;
            }
            Enumeration<URL> superUrls = super.getResources(name);
            if (superUrls != null && superUrls.hasMoreElements()) {
                return superUrls;
            }
        }
        for (IResourceFinder resourceFinder : this.resourceFinders) {
            URL resource = resourceFinder.findResource(name);
            if (resource == null) continue;
            return this.createEnumeration(resource);
        }
        this.logger.debug(name + " not found in resourceFinders:" + this.resourceFinders);
        if (this.postDelegating) {
            resources = this.getParent().getResources(name);
            if (resources != null && resources.hasMoreElements()) {
                return resources;
            }
            return super.getResources(name);
        }
        return EMPTY_ENUM;
    }

    private Enumeration<URL> createEnumeration(final URL url) {
        return new Enumeration<URL>(){
            public boolean advanced = false;

            @Override
            public boolean hasMoreElements() {
                return url != null && !this.advanced;
            }

            @Override
            public URL nextElement() {
                if (this.advanced) {
                    throw new IllegalStateException("no more elements");
                }
                this.advanced = true;
                return url;
            }
        };
    }

    public FileSystemClassLoader(ILogger logger) {
        this(logger, false);
    }

    public FileSystemClassLoader(ILogger logger, boolean postDelegating) {
        this.logger = logger;
        this.postDelegating = postDelegating;
    }

    public FileSystemClassLoader(ClassLoader parentClassLoader, ILogger logger) {
        this(parentClassLoader, logger, false);
    }

    public FileSystemClassLoader(ClassLoader parentClassLoader, ILogger logger, boolean postDelegating) {
        super(parentClassLoader);
        this.logger = logger;
        this.postDelegating = postDelegating;
    }

    public void setClassLoaderContext(String context) {
        this.classLoaderContext = context;
    }

    public String[] getClassPath() {
        ArrayList<String> classPath = new ArrayList<String>();
        for (IResourceFinder resourceFinder : this.resourceFinders) {
            classPath.addAll(resourceFinder.getSearchPath());
        }
        return classPath.toArray(new String[classPath.size()]);
    }

    public String printClassPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class Loader :").append(this.classLoaderContext);
        sb.append("\n######### ClassPath #############\n");
        for (String classPathArchive : this.getClassPath()) {
            sb.append(classPathArchive);
            sb.append("\n");
        }
        sb.append("######### End ClassPath ###########");
        return sb.toString();
    }

    public void addJarFile(String path) {
        this.logger.debug("adding Jar file to classpath [" + path + "]");
        ArchiveResourceFinder e = new ArchiveResourceFinder();
        e.addArchiveToSearchPath(path);
        this.resourceFinders.add(e);
    }

    public void addDirectory(String path) {
        this.logger.debug("adding directory to classpath [" + path + "]");
        DirResourceFinder dirResourceFinder = new DirResourceFinder();
        dirResourceFinder.addDirectoryToSearchPath(path);
        this.resourceFinders.add(dirResourceFinder);
    }

    public void addDirectoryContainingJars(String directoryPath) throws IOException {
        File[] files;
        if (!new File(directoryPath).isDirectory()) {
            throw new IOException("Directory Path[" + directoryPath + "] does not point to a directory");
        }
        for (File jarFile : files = new File(directoryPath).listFiles()) {
            if (!this.isArchive(jarFile.getName())) continue;
            this.addJarFile(jarFile.getCanonicalPath());
        }
    }

    public void parseAndAddClassPath(String classpathString, boolean loadAllJarsFromDir, String relativeDirectoryRoot, boolean ignoreInvalidEntries) throws IOException {
        this.logger.debug("Parsing and Adding ClassPath - RAW String - [" + classpathString + "]");
        if (this.getClassPathSeparatorAutoParseEnabled()) {
            classpathString = classpathString.replace(":", File.pathSeparator);
            classpathString = classpathString.replace(";", File.pathSeparator);
        }
        StringTokenizer cpTokens = new StringTokenizer(classpathString, File.pathSeparator);
        while (cpTokens.hasMoreTokens()) {
            String cpEntry = cpTokens.nextToken();
            this.logger.debug("Directory root for resolving relative path [" + relativeDirectoryRoot + "]");
            File file = this.resolveFile(cpEntry, relativeDirectoryRoot, ignoreInvalidEntries);
            if (!file.exists()) {
                if (ignoreInvalidEntries) continue;
                throw new IOException("Invalid Classpath Entry -" + cpEntry + "Does not exist");
            }
            if (file.isDirectory()) {
                this.addDirectory(file.getCanonicalPath());
                if (!loadAllJarsFromDir) continue;
                this.logger.debug("Adding all jars in directory to classpath [" + file.getCanonicalPath() + "]");
                this.addDirectoryContainingJars(file.getCanonicalPath());
                continue;
            }
            this.addJarFile(file.getCanonicalPath());
        }
    }

    private boolean getClassPathSeparatorAutoParseEnabled() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_CLASS_PATH_SEPARATOR_AUTO_PARSE_ENABLED, "true"));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.postDelegating) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    clazz = this.getParent().loadClass(name);
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            this.resolveClass(clazz);
            return clazz;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("findClass: " + name);
        }
        try {
            ArchiveResourceFinder.ArchiveClassInfo classBytesWithManifest = null;
            byte[] classBytes = null;
            for (IResourceFinder resourceFinder : this.resourceFinders) {
                if (resourceFinder instanceof ArchiveResourceFinder) {
                    classBytesWithManifest = ((ArchiveResourceFinder)resourceFinder).findArchiveClassInfo(name);
                    if (classBytesWithManifest != null) {
                        classBytes = classBytesWithManifest.getClassBytes();
                    }
                } else {
                    classBytes = resourceFinder.findClassfromPath(name);
                    classBytesWithManifest = new ArchiveResourceFinder.ArchiveClassInfo();
                    classBytesWithManifest.setClassBytes(classBytes);
                }
                if (classBytes == null) continue;
                break;
            }
            if (classBytesWithManifest != null && classBytes != null) {
                this.definePackage(name, classBytesWithManifest.getManifest());
                Class<?> value = this.defineClass(name, classBytes, 0, classBytes.length);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("FOUND!" + value);
                }
                return value;
            }
        }
        catch (Throwable e) {
            throw new ClassNotFoundException("Could not read Class Bytes for class [" + name + "]", e);
        }
        throw new ClassNotFoundException(name);
    }

    private void definePackage(String name, Manifest man) throws IOException {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            if (pkg != null) {
                if (!pkg.isSealed() && man != null && this.isSealed(pkgname, man)) {
                    if (!this.ignoreSecurityExceptionOnDefinePackage) {
                        throw new SecurityException("sealing violation: can't seal package " + pkgname + " already loaded");
                    }
                    this.logger.warn("Package already loaded [" + pkgname + "]");
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, null);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        try {
            for (IResourceFinder resourceFinder : this.resourceFinders) {
                InputStream is = resourceFinder.findResourceAsStream(resourceName);
                if (is == null) continue;
                return is;
            }
        }
        catch (IOException e) {
            return super.getResourceAsStream(resourceName);
        }
        return super.getResourceAsStream(resourceName);
    }

    @Override
    public URL getResource(String resourceName) {
        try {
            for (IResourceFinder resourceFinder : this.resourceFinders) {
                URL url = resourceFinder.findResource(resourceName);
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return super.getResource(resourceName);
        }
        return super.getResource(resourceName);
    }

    private File resolveFile(String cpEntry, String relativeDirectoryRoot, boolean ignoreInvalidEntries) throws IOException {
        File file = PathResolver.getResolvedFileOnDisk(relativeDirectoryRoot, cpEntry);
        if (!file.exists() && !ignoreInvalidEntries) {
            throw new IOException("Invalid Classpath Entry , File does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    private boolean isArchive(String path) {
        return path.endsWith(".jar") || path.endsWith(".zip");
    }

    public void setIgnoreSecurityExceptionOnDefinePackage(boolean ignorePackageCheck) {
        this.ignoreSecurityExceptionOnDefinePackage = ignorePackageCheck;
    }

    public boolean isIgnoreSecurityExceptionOnDefinePackage() {
        return this.ignoreSecurityExceptionOnDefinePackage;
    }
}

