/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.loader;

import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.loader.IResourceFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveResourceFinder
implements IResourceFinder {
    private Set<String> archiveClassPath = new HashSet<String>();
    protected final Map<String, Manifest> archivePathVsManifest = new HashMap<String, Manifest>();

    public void addArchiveToSearchPath(String path) {
        this.archiveClassPath.add(path);
    }

    @Override
    public Set<String> getSearchPath() {
        return this.archiveClassPath;
    }

    @Override
    public byte[] findClassfromPath(String className) throws IOException {
        String classEntryInArchive = className.replace(".", "/") + ".class";
        for (String archivePath : this.archiveClassPath) {
            ArchiveClassInfo classBytesWithManifest = this.searchInArchive(archivePath, classEntryInArchive);
            if (classBytesWithManifest == null) continue;
            return classBytesWithManifest.getClassBytes();
        }
        return null;
    }

    public ArchiveClassInfo findArchiveClassInfo(String className) throws IOException {
        String classEntryInArchive = className.replace(".", "/") + ".class";
        for (String archivePath : this.archiveClassPath) {
            ArchiveClassInfo classBytesWithManifest = this.searchInArchive(archivePath, classEntryInArchive);
            if (classBytesWithManifest == null) continue;
            return classBytesWithManifest;
        }
        return null;
    }

    @Override
    public InputStream findResourceAsStream(String resourceName) throws IOException {
        for (String archivePath : this.archiveClassPath) {
            InputStream is = this.getStreamFromArchive(archivePath, resourceName);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public URL findResource(String resourceName) throws IOException {
        for (String archivePath : this.archiveClassPath) {
            URL url = this.getURLFromArchive(archivePath, resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private InputStream getStreamFromArchive(String archivePath, String resourceEntry) throws IOException {
        ZipFile zipFile = new ZipFile(archivePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.equals(resourceEntry)) continue;
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL getURLFromArchive(String archivePath, String resourceEntry) throws IOException {
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(archivePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.equals(resourceEntry)) continue;
                try {
                    File file = new File(archivePath);
                    String archiveURI = file.getAbsoluteFile().toURI().toString();
                    String resourceURI = "jar:" + archiveURI + "!/" + resourceEntry;
                    URL uRL = new URI(resourceURI).toURL();
                    return uRL;
                }
                catch (URISyntaxException e) {
                    try {
                        IOException ioe = new IOException("invalid uri");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveClassInfo searchInArchive(String archivePath, String classEntry) throws IOException {
        ArchiveClassInfo classBytesWithManifest = null;
        Manifest manifest = null;
        boolean checkForManifest = !this.archivePathVsManifest.containsKey(archivePath);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archivePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (checkForManifest && entryName.equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(zipFile.getInputStream(entry));
                    checkForManifest = false;
                    this.archivePathVsManifest.put(archivePath, manifest);
                }
                if (entryName.equals(classEntry)) {
                    classBytesWithManifest = new ArchiveClassInfo();
                    classBytesWithManifest.setClassBytes(FileUtil.inputStreamToByteArray(zipFile.getInputStream(entry)));
                }
                if (checkForManifest || classBytesWithManifest == null) continue;
                break;
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (checkForManifest) {
                this.archivePathVsManifest.put(archivePath, manifest);
            }
        }
        if (classBytesWithManifest != null) {
            classBytesWithManifest.setManifest(this.archivePathVsManifest.get(archivePath));
        }
        return classBytesWithManifest;
    }

    public static class ArchiveClassInfo {
        private byte[] classBytes;
        private Manifest manifest;

        public byte[] getClassBytes() {
            return this.classBytes;
        }

        public void setClassBytes(byte[] classBytes) {
            this.classBytes = classBytes;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public void setManifest(Manifest manifest) {
            this.manifest = manifest;
        }
    }
}

