/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;

class SchedulerMonitor
extends Thread {
    private static final long DEFAULT_POLL_FREQUENCY = 60L;
    private static final String POLL_FREQUENCY_PROP = "appdynamics.scheduler.monitor.poll.frequency";
    private static final long pollFrequency = StringOperations.safeParseLong(SystemUtils.getProperty("appdynamics.scheduler.monitor.poll.frequency"), 60L) * 1000L;
    private IAgentScheduledThreadPoolExecutor toMonitor;
    private ILogger logger;
    private volatile boolean shouldStop;

    SchedulerMonitor(IAgentScheduledThreadPoolExecutor toMonitor, ILogger logger) {
        super("SchedulerMonitor");
        this.toMonitor = toMonitor;
        this.logger = logger;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                SchedulerMonitor schedulerMonitor = this;
                synchronized (schedulerMonitor) {
                    if (!this.shouldStop) {
                        this.wait(pollFrequency);
                    }
                    if (this.shouldStop) {
                        break;
                    }
                }
                this.toMonitor.look();
            }
        }
        catch (InterruptedException e) {
            this.logger.debug(e.toString(), e);
        }
    }

    synchronized void stopMonitoring() {
        this.shouldStop = true;
        this.notify();
    }
}

