/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionTracker {
    public static final boolean ENABLED = Boolean.getBoolean("appdynamics.scheduler.track");
    private static ConcurrentHashMap<String, AtomicInteger> counts = null;

    static void track(Runnable r) {
        if (ENABLED && counts != null) {
            String name = ExecutionTracker.getName(r);
            AtomicInteger value = counts.get(name);
            if (value == null) {
                value = new AtomicInteger();
                counts.putIfAbsent(name, value);
                value = counts.get(name);
            }
            value.incrementAndGet();
        }
    }

    private static String getName(Runnable r) {
        try {
            Object sync = ExecutionTracker.getField(r, "sync");
            Object callable = ExecutionTracker.getField(sync, "callable");
            Object task = ExecutionTracker.getField(callable, "task");
            Object command = ExecutionTracker.getField(task, "val$command");
            return command.getClass().getName();
        }
        catch (Throwable e) {
            return e.getMessage();
        }
    }

    private static Object getField(Object r, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ExecutionTracker.getDeclaredField(r.getClass(), fieldName, true).get(r);
    }

    private static Field getDeclaredField(Class cls, String fieldName, boolean scanSuperClass) throws NoSuchFieldException {
        Field field = null;
        try {
            field = cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (field != null) {
            field.setAccessible(true);
            return field;
        }
        if (scanSuperClass) {
            while (cls != null) {
                try {
                    field = cls.getDeclaredField(fieldName);
                    if (field != null) {
                        break;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                cls = cls.getSuperclass();
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            field.setAccessible(true);
            return field;
        }
        field = cls.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    static {
        if (ENABLED) {
            counts = new ConcurrentHashMap();
            new Timer(true).schedule(new TimerTask(){

                @Override
                public void run() {
                    System.out.println("SCHEDULE TRACK: =============================================================");
                    for (Map.Entry nameVsCount : counts.entrySet()) {
                        int value = ((AtomicInteger)nameVsCount.getValue()).getAndSet(0);
                        if (value == 0) continue;
                        System.out.println("SCHEDULE TRACK: " + (String)nameVsCount.getKey() + " = " + value);
                    }
                }
            }, 15000L, 15000L);
        }
    }
}

