/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.javaspecific.scheduler.ADFutureTask;
import com.singularity.ee.util.javaspecific.scheduler.ADScheduledThreadPoolExecutor;
import com.singularity.ee.util.javaspecific.scheduler.AgentScheduledFutureImpl;
import com.singularity.ee.util.javaspecific.scheduler.IAgentRunnableMeasurer;
import com.singularity.ee.util.javaspecific.threads.IAgentCallable;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class AgentScheduledExecutorServiceImpl
implements IAgentScheduledExecutorService {
    protected final ADScheduledThreadPoolExecutor scheduledExecutorService;
    protected ILogger logger;

    AgentScheduledExecutorServiceImpl(ADScheduledThreadPoolExecutor scheduledExecutorService, ILogger logger) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.logger = logger;
    }

    @Override
    public IAgentScheduledFuture scheduleAtFixedRate(IAgentRunnable command, long initialDelay, long period, AgentTimeUnit unit) {
        ADFutureTask future = (ADFutureTask)((Object)this.scheduledExecutorService.scheduleAtFixedRate(new SafeRunnable(this.logger, command), initialDelay, period, this.getTimeUnit(unit)));
        if (future != null) {
            return new AgentScheduledFutureImpl(future);
        }
        return null;
    }

    @Override
    public IAgentScheduledFuture scheduleWithFixedDelay(IAgentRunnable command, long initialDelay, long delay, AgentTimeUnit unit) {
        ADFutureTask future = (ADFutureTask)((Object)this.scheduledExecutorService.scheduleWithFixedDelay(new SafeRunnable(this.logger, command), initialDelay, delay, this.getTimeUnit(unit)));
        if (future != null) {
            return new AgentScheduledFutureImpl(future);
        }
        return null;
    }

    @Override
    public IAgentScheduledFuture schedule(IAgentRunnable command, long delay, AgentTimeUnit unit) {
        ADFutureTask future = (ADFutureTask)((Object)this.scheduledExecutorService.schedule(new SafeRunnable(this.logger, command), delay, this.getTimeUnit(unit)));
        return new AgentScheduledFutureImpl(future);
    }

    @Override
    public IAgentScheduledFuture schedule(final IAgentCallable command, long delay, AgentTimeUnit unit) {
        ADFutureTask future = (ADFutureTask)((Object)this.scheduledExecutorService.schedule(new Callable(){

            public Object call() throws Exception {
                return command.call();
            }
        }, delay, this.getTimeUnit(unit)));
        return new AgentScheduledFutureImpl(future);
    }

    @Override
    public void shutdownNow() {
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public boolean awaitTermination(long delay, AgentTimeUnit unit) throws InterruptedException {
        return this.scheduledExecutorService.awaitTermination(delay, this.getTimeUnit(unit));
    }

    private TimeUnit getTimeUnit(AgentTimeUnit unit) {
        switch (unit) {
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new IllegalArgumentException(unit.name());
    }

    protected abstract IAgentRunnableMeasurer getMeasurer();

    private class SafeRunnable
    implements IAgentRunnable {
        ILogger logger;
        IAgentRunnable delegate;

        private SafeRunnable(ILogger logger, IAgentRunnable delegate) {
            this.logger = logger;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = 0L;
            long cpuStartTime = 0L;
            IAgentRunnableMeasurer measurer = AgentScheduledExecutorServiceImpl.this.getMeasurer();
            if (measurer != null && measurer.isMeasurementStarted(this.delegate)) {
                startTime = measurer.getStartTimeInNanos();
                cpuStartTime = measurer.getStartCPUTimeInNanos();
            }
            try {
                this.delegate.run();
            }
            catch (Throwable e) {
                if (null != this.logger) {
                    try {
                        this.logger.error("Error executing task - ", e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (startTime > 0L) {
                    measurer.onAgentRunnableComplete(startTime, cpuStartTime, this.delegate);
                }
            }
        }
    }
}

