/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class ADHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public ADHashSet() {
        this.map = new HashMap();
    }

    public ADHashSet(Collection<? extends E> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public ADHashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public ADHashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    ADHashSet(int initialCapacity, float loadFactor, boolean dummy) {
        this.map = new LinkedHashMap<E, Object>(initialCapacity, loadFactor);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Deprecated
    public E getOriginalKey(E newKey) {
        for (E e : this.map.keySet()) {
            if (!e.equals(newKey)) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            ADHashSet newSet = (ADHashSet)super.clone();
            newSet.map = (HashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

