/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.collections;

import com.singularity.ee.util.javaspecific.collections.ADIterator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class ADConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private volatile boolean sizeDirty = true;
    private int sizeCached;
    private static final Object DUMMY = new Object();
    private static final ConcurrentHashMap<WeakReference<ADConcurrentHashMap>, Object> instanceTracker = new ConcurrentHashMap();
    private static final ReferenceQueue<ADConcurrentHashMap> refQueue = new ReferenceQueue();

    public ADConcurrentHashMap() {
        ADConcurrentHashMap.addInstance(this);
    }

    public ADConcurrentHashMap(int initialCapacity) {
        super(initialCapacity);
        ADConcurrentHashMap.addInstance(this);
    }

    public static ConcurrentHashMap<WeakReference<ADConcurrentHashMap>, Object> getInstanceTracker() {
        return ADConcurrentHashMap.purgeInstanceTracker();
    }

    public ADIterator<K> keySetIterator() {
        return new ADIterator(super.keySet().iterator());
    }

    public ADIterator<V> valuesIterator() {
        return new ADIterator(super.values().iterator());
    }

    public Collection<K> getAllKeys() {
        return super.keySet();
    }

    public Collection<V> getAllValues() {
        return super.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        try {
            V v2 = super.put(k, v);
            return v2;
        }
        finally {
            this.sizeDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        try {
            V v2 = super.putIfAbsent(k, v);
            return v2;
        }
        finally {
            this.sizeDirty = true;
        }
    }

    @Override
    public V remove(Object o) {
        try {
            Object v = super.remove(o);
            return v;
        }
        finally {
            this.sizeDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o, Object o1) {
        try {
            boolean bl = super.remove(o, o1);
            return bl;
        }
        finally {
            this.sizeDirty = true;
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
        }
        finally {
            this.sizeDirty = true;
        }
    }

    public int fastApproximateSize() {
        if (this.sizeDirty) {
            boolean cachedSizeDirty = this.sizeDirty;
            this.sizeCached = super.size();
            if (cachedSizeDirty == this.sizeDirty) {
                this.sizeDirty = false;
            }
        }
        return this.sizeCached;
    }

    public boolean isADCHMEmpty() {
        return this.isEmpty();
    }

    private static void addInstance(ADConcurrentHashMap newInstance) {
        ADConcurrentHashMap.purgeInstanceTracker();
        WeakReference<ADConcurrentHashMap> refToMap = new WeakReference<ADConcurrentHashMap>(newInstance, refQueue);
        instanceTracker.put(refToMap, DUMMY);
    }

    private static ConcurrentHashMap<WeakReference<ADConcurrentHashMap>, Object> purgeInstanceTracker() {
        WeakReference refToMap;
        while ((refToMap = (WeakReference)refQueue.poll()) != null) {
            instanceTracker.remove(refToMap);
        }
        return instanceTracker;
    }
}

