/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.io;

import com.singularity.ee.util.io.UnsynchronizedByteArrayOutputStream;
import com.singularity.ee.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    public static char[] invalidChars = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String REGEXP_INVALID_FILENAME_CHARS = "(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+";
    public static final long MAX_UPLOADED_FILE_SIZE_BYTES = 0x6400000L;
    public static final long MAX_FILE_UPLOAD_COUNT = 100L;
    public static final long MAX_UPLOADED_LOG_SIZE_BYTES = 0xC800000L;
    public static final int MAX_READ_BYTES = 8192;
    private static final AtomicLong uniqueFileIdentifier = new AtomicLong();

    private FileUtil() {
    }

    public static String sanitizeToValidFilePath(String name) {
        for (char invalidChar : invalidChars) {
            name = name.replace(invalidChar, '_');
        }
        return name;
    }

    public static long getUniqueFileIdentifier() {
        return uniqueFileIdentifier.incrementAndGet();
    }

    public static String makeValidFileName(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll(REGEXP_INVALID_FILENAME_CHARS, "-").trim();
    }

    public static void deleteRecursive(File file, ILogger logger) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file1 : files) {
                FileUtil.deleteRecursive(file1, logger);
            }
        }
        if (!file.delete()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n File Permissions for file").append(file.getAbsolutePath());
            sb.append("\n Is Writable ").append(file.canWrite());
            sb.append("\n Is Readable ").append(file.canRead());
            logger.debug("Cannot delete file " + file.getAbsolutePath() + " - File permissions " + sb.toString());
            throw new IOException("Could not delete [" + file.getAbsolutePath() + sb.toString() + "]");
        }
    }

    private static byte[] inputStreamToByteArray(InputStream is, int contentLength, boolean contentLengthCertain) throws IOException {
        byte[] bytes = new byte[contentLength];
        int read = is.read(bytes);
        int oneMoreByte = -1;
        if (read == contentLength && contentLengthCertain && (oneMoreByte = is.read()) == -1) {
            return bytes;
        }
        UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream(contentLength);
        while (read > 0) {
            bos.write(bytes, 0, read);
            if (oneMoreByte != -1) {
                bos.write(oneMoreByte);
                oneMoreByte = -1;
            }
            read = is.read(bytes);
        }
        bytes = bos.toByteArray();
        return bytes;
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        return FileUtil.inputStreamToByteArray(is, 1024, false);
    }

    public static byte[] inputStreamToByteArray(InputStream is, int contentLength) throws IOException {
        return FileUtil.inputStreamToByteArray(is, contentLength, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int transferContent(OutputStream os, InputStream in, int maxBufferSize) throws IOException {
        int totalNumberOfBytes = 0;
        byte[] buffer = new byte[maxBufferSize > 0 ? maxBufferSize : 1024];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                os.write(buffer, 0, read);
                totalNumberOfBytes += read;
            }
            os.flush();
            int n = totalNumberOfBytes;
            return n;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Could not find the source srcFile " + srcFile);
        }
        if (!destFile.exists() && !destFile.createNewFile()) {
            throw new IOException("Could not create the destination srcFile " + destFile.getAbsolutePath());
        }
        FileInputStream srcStream = new FileInputStream(srcFile);
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            byte[] bytes = new byte[5120];
            int i = srcStream.read(bytes);
            while (i > 0) {
                destStream.write(bytes, 0, i);
                i = srcStream.read(bytes);
            }
        }
        finally {
            try {
                srcStream.close();
            }
            catch (IOException iOException) {}
            try {
                destStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStringInLine(File originalFile, String line, String pattern, String replacement) throws IOException {
        File tempFile = File.createTempFile("temp", "temp");
        BufferedReader reader = new BufferedReader(new FileReader(originalFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        try {
            String lineRead;
            while ((lineRead = reader.readLine()) != null) {
                if (!lineRead.equals(line)) continue;
                String replacedLine = lineRead.replaceAll(pattern, replacement);
                writer.write(replacedLine);
                writer.newLine();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                originalFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                tempFile.renameTo(originalFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStringInLine(File originalFile, File destinationFile, String line, String pattern, String replacement) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(originalFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
        try {
            String lineRead;
            while ((lineRead = reader.readLine()) != null) {
                if (!lineRead.equals(line)) continue;
                String replacedLine = lineRead.replaceAll(pattern, replacement);
                writer.write(replacedLine);
                writer.newLine();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStringsInLines(File file, Map<String, StringReplace> replaceMap) throws IOException {
        File tempFile = File.createTempFile("temp", "temp");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        try {
            String lineRead;
            while ((lineRead = reader.readLine()) != null) {
                if (!replaceMap.containsKey(lineRead)) continue;
                StringReplace strReplace = replaceMap.get(lineRead);
                String replacedLine = lineRead.replaceAll(strReplace.getPattern(), strReplace.getReplacement());
                writer.write(replacedLine);
                writer.newLine();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                tempFile.renameTo(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStringsInLines(File originalFile, File destinationFile, Map<String, StringReplace> replaceMap) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(originalFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
        try {
            String lineRead;
            while ((lineRead = reader.readLine()) != null) {
                if (!replaceMap.containsKey(lineRead)) continue;
                StringReplace strReplace = replaceMap.get(lineRead);
                String replacedLine = lineRead.replaceAll(strReplace.getPattern(), strReplace.getReplacement());
                writer.write(replacedLine);
                writer.newLine();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void checkAccessPermissionsForDirectory(File file, boolean checkRead, boolean checkWrite) {
        if (!file.exists()) {
            throw new RuntimeException("File [" + file + "] does not exist");
        }
        if (file.isDirectory()) {
            File[] files;
            try {
                if (checkWrite) {
                    File _file = File.createTempFile("testfile", null, file);
                    _file.delete();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write to directory [" + file + "] with exception : ", e);
            }
            if (checkRead && null == (files = file.listFiles())) {
                throw new RuntimeException("An exception occurred while listing files in the directory [" + file + "]. Please make sure the directory has permissions to read or list files.");
            }
        }
    }

    public static void checkAccessPermissionsForFile(File file, boolean checkRead, boolean checkWrite) {
        if (!file.exists()) {
            throw new RuntimeException("File [" + file + "] does not exist");
        }
        RandomAccessFile raf = null;
        try {
            if (checkRead && checkWrite) {
                raf = new RandomAccessFile(file, "rw");
                raf.close();
                raf = null;
            } else if (checkRead) {
                raf = new RandomAccessFile(file, "r");
                raf.close();
                raf = null;
            } else if (checkWrite) {
                raf = new RandomAccessFile(file, "w");
                raf.close();
                raf = null;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Problem accessing file [" + file + "]  : ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem accessing file [" + file + "]  : ", e);
        }
        finally {
            try {
                if (null != raf) {
                    raf.close();
                    raf = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing [" + raf + "]", e);
            }
        }
    }

    public static void checkAccessPermissionsRecursively(String rootDir, boolean canRead, boolean canWrite) {
        LinkedList<File> queue = new LinkedList<File>();
        File installDir = new File(rootDir);
        queue.add(installDir);
        while (!queue.isEmpty()) {
            File file = (File)queue.poll();
            try {
                if (!file.exists()) {
                    throw new RuntimeException("File [" + file + "] does not exist");
                }
                if (file.isDirectory()) {
                    FileUtil.checkAccessPermissionsForDirectory(file, canRead, canWrite);
                    continue;
                }
                FileUtil.checkAccessPermissionsForFile(file, canRead, canWrite);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Permission check failed for file [" + file + "] with exception : ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(String taskZipFile, String taskDir) throws IOException {
        ZipFile zipFile = new ZipFile(taskZipFile);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        File f = null;
        FileOutputStream fos = null;
        while (enumeration.hasMoreElements()) {
            try {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream eis = zipFile.getInputStream(zipEntry);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                f = new File(taskDir + File.separator + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                f.createNewFile();
                fos = new FileOutputStream(f);
                while ((bytesRead = eis.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos == null) continue;
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(File fileObject) throws IOException {
        if (fileObject.exists() && fileObject.canRead()) {
            BufferedReader reader = null;
            try {
                String lineRead;
                reader = new BufferedReader(new FileReader(fileObject));
                String string = lineRead = reader.readLine();
                return string;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static class StringReplace {
        private final String pattern;
        private final String replacement;

        private StringReplace(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

