/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class Chmod {
    public static final String CHMOD_COMMAND = "chmod";
    public static final String ALL_PERMISSIONS = "777";
    public static final String RECURSIVE_FLAG = "-R";
    public static final String STANDARD_PERMISSIONS = "755";

    private Chmod() {
    }

    public static boolean applyAllPermissionsToDirRecursively(File dir) throws IOException, InterruptedException {
        Chmod.checkExists(dir);
        Chmod.checkDirectory(dir);
        return Chmod.applyPermissions(dir, true, ALL_PERMISSIONS);
    }

    public static boolean applyPermissionsToDirRecursively(File dir, EnumSet<Who> who, EnumSet<Permissions> permissions) throws IOException, InterruptedException {
        if (who.isEmpty() || permissions.isEmpty()) {
            return false;
        }
        Chmod.checkExists(dir);
        Chmod.checkDirectory(dir);
        String permissionString = Chmod.buildPermissionString(who, permissions);
        return Chmod.applyPermissions(dir, true, permissionString);
    }

    public static boolean applyAllPermissionsToFile(File file) throws IOException, InterruptedException {
        Chmod.checkExists(file);
        Chmod.checkFile(file);
        return Chmod.applyPermissions(file, false, ALL_PERMISSIONS);
    }

    public static boolean applyAllPermissionsExceptGroupAndWorldWrite(File file) throws IOException, InterruptedException {
        Chmod.checkExists(file);
        Chmod.checkFile(file);
        return Chmod.applyPermissions(file, false, STANDARD_PERMISSIONS);
    }

    public static boolean applyPermissionsToFile(File file, EnumSet<Who> who, EnumSet<Permissions> permissions) throws IOException, InterruptedException {
        if (who.isEmpty() || permissions.isEmpty()) {
            return false;
        }
        Chmod.checkExists(file);
        Chmod.checkFile(file);
        String permissionString = Chmod.buildPermissionString(who, permissions);
        return Chmod.applyPermissions(file, false, permissionString);
    }

    public static boolean applyPermissions(File file, boolean recursive, String permissionString) throws IOException, InterruptedException {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            Process process;
            ArrayList<String> argv = new ArrayList<String>();
            argv.add(CHMOD_COMMAND);
            if (recursive) {
                argv.add(RECURSIVE_FLAG);
            }
            argv.add(permissionString);
            argv.add(file.getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(argv);
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                IOException exception = new IOException("Error applying permissions to dir [" + file.getAbsolutePath() + "]");
                exception.initCause(e);
                throw exception;
            }
            process.waitFor();
            return true;
        }
        return false;
    }

    protected static String buildPermissionString(EnumSet<Who> who, EnumSet<Permissions> permissions) {
        StringBuilder builder = new StringBuilder();
        if (who.contains((Object)Who.USER)) {
            builder.append("u");
        }
        if (who.contains((Object)Who.GROUP)) {
            builder.append("g");
        }
        if (who.contains((Object)Who.OTHER)) {
            builder.append("o");
        }
        builder.append("+");
        if (permissions.contains((Object)Permissions.READ)) {
            builder.append("r");
        }
        if (permissions.contains((Object)Permissions.WRITE)) {
            builder.append("w");
        }
        if (permissions.contains((Object)Permissions.EXECUTE)) {
            builder.append("x");
        }
        return builder.toString();
    }

    private static void checkExists(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("The path [" + file.getAbsolutePath() + "] does not exist");
        }
    }

    private static void checkDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("The path [" + dir.getAbsolutePath() + "] must be a directory");
        }
    }

    private static void checkFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("The path [" + file.getAbsolutePath() + "] must be a file");
        }
    }

    public static enum Who {
        USER,
        GROUP,
        OTHER;

    }

    public static enum Permissions {
        READ,
        WRITE,
        EXECUTE;

    }
}

