/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.fleetmanagement;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;

public class AgentManagementUtil {
    public static String getSha1ForIdentifyingPropertiesWrapper(SortedMap<String, Object> properties) {
        TreeMap<String, String> stringProperties = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            stringProperties.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return AgentManagementUtil.getSha1ForIdentifyingProperties(stringProperties);
    }

    public static String getSha1ForIdentifyingProperties(SortedMap<String, String> properties) {
        String propertiesStr = AgentManagementUtil.getIdentifyingPropertiesAsString(properties);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] sha1String = digest.digest(propertiesStr.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])sha1String);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getIdentifyingPropertiesAsString(SortedMap<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            sb.append(property.getKey()).append("=").append(property.getValue()).append(";");
        }
        return sb.toString();
    }
}

