/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.compress;

import com.singularity.ee.util.compress.CompressionUtility;
import com.singularity.ee.util.compress.ICompressedFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class ACompressedFile
implements ICompressedFile {
    public static final int BUFFER = 2048;
    private String name;
    private boolean isDirectory;
    private long checkSum;
    private Serializable info;
    protected String destinationDir;
    private transient File originalFile;

    public ACompressedFile(String fileOrDirectory) throws IOException {
        this.originalFile = new File(fileOrDirectory);
        if (!this.originalFile.exists()) {
            throw new IOException("File [" + this.originalFile.getAbsolutePath() + "] does not exist.");
        }
        this.isDirectory = this.originalFile.isDirectory();
        this.name = this.originalFile.getName();
    }

    public ACompressedFile(String fileOrDirectory, Serializable info) throws IOException {
        this(fileOrDirectory);
        this.info = info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public long getCheckSum() {
        return this.checkSum;
    }

    @Override
    public Serializable getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(Serializable info) {
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream oos) throws IOException {
        String tempArchivePath = null;
        FileInputStream fis = null;
        try {
            tempArchivePath = System.getProperty("java.io.tmpdir") + File.separator + this.name + "_.tmp";
            this.checkSum = this.originalFile.isDirectory() ? ACompressedFile.createArchiveFromDirectoryAndReturnCheckSum(tempArchivePath, this.originalFile.getAbsolutePath()) : ACompressedFile.compressFileAndReturnCheckSum(tempArchivePath, this.originalFile.getAbsolutePath());
            System.out.println("writing check sum for ->" + tempArchivePath + "- " + this.checkSum);
            oos.defaultWriteObject();
            fis = new FileInputStream(tempArchivePath);
            byte[] fileBytes = new byte[2048];
            int i = fis.read(fileBytes);
            while (i > 0) {
                oos.write(fileBytes, 0, i);
                oos.flush();
                i = fis.read(fileBytes);
            }
        }
        catch (Throwable throwable) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                new File(tempArchivePath).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new File(tempArchivePath).delete();
        }
        catch (Exception exception) {}
    }

    protected abstract String getDestinationOutputDir();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        System.out.println("after write object checksum->" + this.checkSum);
        FileOutputStream fos = null;
        File tempArchive = null;
        try {
            byte[] fileBytes = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = ois.read(fileBytes);
            while (i > 0) {
                baos.write(fileBytes, 0, i);
                i = ois.read(fileBytes);
            }
            tempArchive = new File(System.getProperty("java.io.tmpdir") + File.separator + this.name + "_.tmp1");
            fos = new FileOutputStream(tempArchive);
            fos.write(baos.toByteArray());
            System.out.println("written file to ->" + tempArchive);
            System.out.println("extracing archive to ->" + tempArchive.getAbsolutePath());
            System.out.println("Dest output dir ->" + this.getDestinationOutputDir());
            CompressionUtility.extractArchive(tempArchive.getAbsolutePath(), this.getDestinationOutputDir(), null);
        }
        finally {
            System.out.println("eventually -> write object ->" + this.name);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (tempArchive != null) {
                try {
                    tempArchive.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static long createArchiveFromDirectoryAndReturnCheckSum(String pathOfArchiveToBeCreated, String srcDirPath) throws IOException {
        File srcDir = new File(srcDirPath);
        return ACompressedFile.createArchive(new File(pathOfArchiveToBeCreated), srcDir);
    }

    public static long createArchive(File file, File srcDir) throws FileNotFoundException, IOException {
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Expected Directory as an argument " + srcDir);
        }
        return ACompressedFile.createArchiveInternal(file, srcDir, srcDir.listFiles());
    }

    public static long createArchive(File file, File srcDir, File[] contents) throws FileNotFoundException, IOException {
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Expected Directory as an argument " + srcDir);
        }
        return ACompressedFile.createArchiveInternal(file, srcDir, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createArchiveInternal(File file, File srcDir, File[] contents) throws FileNotFoundException, IOException {
        BufferedInputStream origin = null;
        FileOutputStream dest = null;
        CheckedOutputStream checksum = null;
        ZipOutputStream out = null;
        try {
            dest = new FileOutputStream(file);
            checksum = new CheckedOutputStream(dest, new Adler32());
            out = new ZipOutputStream(new BufferedOutputStream(checksum));
            byte[] data = new byte[2048];
            File[] files = contents;
            for (int i = 0; i < files.length; ++i) {
                int count;
                System.out.println("File Name ->" + files[i].getName());
                if (files[i].isDirectory()) {
                    System.out.println("adding from DIr ->" + files[i].getAbsolutePath());
                    ACompressedFile.addFilesFromDirectory(files[i].getAbsolutePath(), files[i].getName(), out);
                    continue;
                }
                System.out.println("Adding: " + files[i]);
                FileInputStream fi = new FileInputStream(files[i]);
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(files[i].getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            System.out.println("checksum:" + checksum.getChecksum().getValue());
            long l = checksum.getChecksum().getValue();
            return l;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void addFilesFromDirectory(String directory, String entrySuffix, ZipOutputStream out) throws IOException {
        BufferedInputStream origin = null;
        byte[] data = new byte[2048];
        File f = new File(directory);
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int count;
            if (files[i].isDirectory()) {
                System.out.println("adding from dir 1->" + files[i].getName());
                ACompressedFile.addFilesFromDirectory(files[i].getAbsolutePath(), entrySuffix + "/" + files[i].getName(), out);
                continue;
            }
            System.out.println("Adding: " + files[i]);
            FileInputStream fi = new FileInputStream(files[i]);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(entrySuffix + "/" + files[i].getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long compressFileAndReturnCheckSum(String pathOfArchiveToBeCreated, String file) throws IOException {
        if (new File(file).isDirectory()) {
            throw new IllegalArgumentException("Expected File as an argument " + file);
        }
        BufferedInputStream origin = null;
        FileOutputStream dest = null;
        CheckedOutputStream checksum = null;
        ZipOutputStream out = null;
        try {
            int count;
            dest = new FileOutputStream(pathOfArchiveToBeCreated);
            checksum = new CheckedOutputStream(dest, new Adler32());
            out = new ZipOutputStream(new BufferedOutputStream(checksum));
            byte[] data = new byte[2048];
            File f = new File(file);
            System.out.println("Adding: " + f);
            FileInputStream fis = new FileInputStream(f);
            origin = new BufferedInputStream(fis, 2048);
            ZipEntry entry = new ZipEntry(f.getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            System.out.println("checksum:" + checksum.getChecksum().getValue());
            long l = checksum.getChecksum().getValue();
            return l;
        }
        finally {
            try {
                origin.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

