/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.bounded;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.logging.ILogger;
import java.util.Collection;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class SharedBoundedDelayQueue<E extends Delayed>
extends DelayQueue<E>
implements IBoundedCollection {
    SharedBoundsEnforcer boundsEnforcer = null;

    public SharedBoundedDelayQueue(int limit) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, limit);
    }

    public SharedBoundedDelayQueue(int limit, BoundsPolicy policy) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, limit, policy);
    }

    public SharedBoundedDelayQueue(int limit, BoundsPolicy policy, ICustomAction customAction) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, limit, policy, customAction);
    }

    public void setILogger(ILogger logger) {
        if (logger != null) {
            this.boundsEnforcer.setLogger(logger);
        }
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }

    @Override
    public boolean add(E e) {
        return this.boundsEnforcer.checkCapacity(1) ? super.add(e) : false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.boundsEnforcer.checkCapacity(c.size()) ? super.addAll(c) : false;
    }

    @Override
    public boolean offer(E e) {
        return this.boundsEnforcer.checkCapacity(1) ? super.offer(e) : false;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.boundsEnforcer.checkCapacity(1) ? super.offer(e, timeout, unit) : false;
    }

    @Override
    public void put(E e) {
        if (this.boundsEnforcer.checkCapacity(1)) {
            super.put(e);
        }
    }
}

