/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.bounded;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.logging.ILogger;

public class SharedBoundedConcurrentHashMap<K, V>
extends ADConcurrentHashMap<K, V>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private static final float BOUNDS_BUFFER_PCT = 0.1f;
    private final SharedBoundsEnforcer boundsEnforcer;

    public SharedBoundedConcurrentHashMap(int initialCapacity, int upperLimit) {
        super(initialCapacity);
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit);
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public SharedBoundedConcurrentHashMap(int upperLimit, BoundsPolicy policy) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit, policy);
        this.boundsEnforcer.setBufferPct(0.1f);
    }

    public void setILogger(ILogger logger) {
        this.boundsEnforcer.setLogger(logger);
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public V put(K k, V v) {
        V returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.put(k, v);
        }
        return returnValue;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        V returnValue = null;
        if (this.get(k) != null || this.boundsEnforcer.checkCapacity(1)) {
            returnValue = super.putIfAbsent(k, v);
        }
        return returnValue;
    }

    @Override
    public int getCurrentSize() {
        return this.fastApproximateSize();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

