/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.logging.ILogger;
import java.util.Collection;

public class CollectionUtils {
    public static <T> void logElements(Collection<T> collection, ILogger logger, LogType logType, int maxElementLength) {
        for (T nextElement : collection) {
            String stringRep = nextElement.toString();
            if (maxElementLength > 0 && stringRep.length() > maxElementLength) {
                stringRep = stringRep.substring(0, maxElementLength) + "...";
            }
            switch (logType) {
                case DEBUG: {
                    logger.debug(stringRep);
                    break;
                }
                case INFO: {
                    logger.info(stringRep);
                    break;
                }
                case WARN: {
                    logger.warn(stringRep);
                    break;
                }
                case ERROR: {
                    logger.error(stringRep);
                }
            }
        }
    }

    public static enum LogType {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

