/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayUtils {
    public static <T> String objectArrayListToString(ArrayList<T> a, int maxLength) {
        if (a == null) {
            return "null";
        }
        int iMax = a.size() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            String stringValue;
            if ((stringValue = String.valueOf(a.get(i))).length() > maxLength) {
                String truncatedStringValue = stringValue.substring(0, maxLength);
                b.append(truncatedStringValue);
                b.append(ArrayUtils.getWarningToken(maxLength));
            } else {
                b.append(stringValue);
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            if (b.length() > maxLength) {
                b.append(ArrayUtils.getWarningToken(maxLength));
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String getWarningToken(int maxLength) {
        return "] ... Max length limit [" + maxLength + "] reached, not all data points were captured";
    }

    private ArrayUtils() {
    }

    public static <T> List<T> union(T[] array1, T[] array2) {
        ArrayList<T> union = new ArrayList<T>();
        if (array1 != null) {
            for (T element : array1) {
                union.add(element);
            }
        }
        if (array2 != null) {
            for (T element : array2) {
                union.add(element);
            }
        }
        return union;
    }

    public static long[] setToPrimitiveArray(Set<Long> set) {
        if (set == null) {
            return null;
        }
        long[] array = new long[set.size()];
        int i = 0;
        for (Long element : set) {
            array[i++] = element;
        }
        return array;
    }

    public static long[] listToPrimitiveArray(List<Long> list) {
        if (list == null) {
            return null;
        }
        long[] array = new long[list.size()];
        int i = 0;
        for (long element : list) {
            array[i++] = element;
        }
        return array;
    }

    public static int[] copyOf(int[] arr, int length) {
        int[] returnArray = new int[length];
        System.arraycopy(arr, 0, returnArray, 0, length);
        return returnArray;
    }

    public static String[] copyOf(String[] arr, int length) {
        String[] returnArray = new String[length];
        System.arraycopy(arr, 0, returnArray, 0, length);
        return returnArray;
    }

    public static Set<Long> primitiveArrayToSet(long[] array) {
        if (array == null) {
            return null;
        }
        HashSet<Long> set = new HashSet<Long>(array.length);
        for (long element : array) {
            set.add(element);
        }
        return set;
    }

    public static List<Long> primitiveArrayToList(long[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long element : array) {
            list.add(element);
        }
        return list;
    }

    public static String arrayFriendlyToString(Object obj) {
        String ret = "";
        if (obj != null) {
            if (ReflectionUtilityCommon.isArray(obj.getClass())) {
                ret = ArrayUtilsHelper.arrayToStringJavaSpecific(obj);
            } else if (ArrayUtilsHelper.checkIfEnumeration(obj)) {
                ret = ArrayUtilsHelper.enumerationToStringJavasSpecific(obj);
            } else {
                try {
                    ret = obj.toString();
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Error :").append(ReflectionUtilityCommon.getName(e.getClass())).append(" while invoking toString : ").append(ReflectionUtilityCommon.getName(obj.getClass()));
                    ret = sb.toString();
                }
            }
        }
        return ret;
    }

    public static <T> T[] createArrayContainingElement(T obj, int size) {
        T[] array = ReflectionUtilityCommon.newArray(obj, size);
        for (int i = 0; i < size; ++i) {
            array[i] = obj;
        }
        return array;
    }

    public static <T> List<T> safeArrayList(T ... objs) {
        if (objs == null) {
            return new ArrayList(0);
        }
        return CollectionHelper.asList(objs);
    }

    public static <T> int getHashCode(T[] obj) {
        if (obj == null) {
            return 0;
        }
        int result = 1;
        for (T element : obj) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean hasLength(T[] array, int length) {
        return array != null && array.length == length;
    }

    public static <T> boolean isIndexInBounds(T[] array, int index) {
        return array != null && array.length > index;
    }

    public static enum ArrayType {
        OBJECT,
        INT,
        FLOAT,
        BOOLEAN,
        BYTE,
        CHAR,
        DOUBLE,
        LONG,
        SHORT;

    }
}

