/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.UnresolvedBackendCallInfo;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.federation.FederatedResolvedBackendResolution;
import com.singularity.ee.rest.controller.request.ExitCallInfoHelper;
import com.singularity.ee.util.compress.CompressedObject;
import java.util.List;

@GenProto
public class ExitCallInfo
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private UnresolvedBackendCallInfo[] resolutionInfo;
    @FieldPosition(value=3)
    private UnresolvedBackendCallInfo[] crossAppResolutionInfo;
    @FieldPosition(value=4)
    private List<FederatedResolvedBackendResolution> federatedResolvedBackends;
    @IgnoreProtoGen
    @JsonProperty
    byte[] compressedResolutionInfo;
    @IgnoreProtoGen
    @JsonProperty
    byte[] compressedCrossAppResolutionInfo;
    @IgnoreProtoGen
    int originalLength;
    @IgnoreProtoGen
    int compressedLength;
    @IgnoreProtoGen
    int crossAppOriginalLength;
    @IgnoreProtoGen
    int crossAppCompressedLength;

    public UnresolvedBackendCallInfo[] getResolutionInfo() {
        if (this.resolutionInfo != null) {
            return this.resolutionInfo;
        }
        if (this.originalLength <= 0) {
            return new UnresolvedBackendCallInfo[0];
        }
        return ExitCallInfoHelper.decompress(this);
    }

    public void setResolutionInfo(UnresolvedBackendCallInfo[] resolutionInfo) {
        this.resolutionInfo = resolutionInfo;
    }

    @JsonIgnore
    public void setCompressedResolutionInfo(CompressedObject compressedIpInfo) {
        if (compressedIpInfo == null) {
            return;
        }
        this.setOriginalLength(compressedIpInfo.getOriginalLength());
        this.setCompressedLength(compressedIpInfo.getCompressedLength());
        this.setCompressedResolutionInfo(compressedIpInfo.getCompressedBytes());
    }

    public byte[] getCompressedResolutionInfo() {
        return this.compressedResolutionInfo;
    }

    public void setCompressedResolutionInfo(byte[] compressedResolutionInfo) {
        this.compressedResolutionInfo = compressedResolutionInfo;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    public void setOriginalLength(int originalLength) {
        this.originalLength = originalLength;
    }

    public int getCompressedLength() {
        return this.compressedLength;
    }

    public void setCompressedLength(int compressedLength) {
        this.compressedLength = compressedLength;
    }

    public List<FederatedResolvedBackendResolution> getFederatedResolvedBackends() {
        return this.federatedResolvedBackends;
    }

    public void setFederatedResolvedBackends(List<FederatedResolvedBackendResolution> federatedResolvedBackends) {
        this.federatedResolvedBackends = federatedResolvedBackends;
    }

    public UnresolvedBackendCallInfo[] getCrossAppResolutionInfo() {
        if (this.crossAppResolutionInfo != null) {
            return this.crossAppResolutionInfo;
        }
        if (this.crossAppOriginalLength <= 0) {
            return new UnresolvedBackendCallInfo[0];
        }
        return ExitCallInfoHelper.decompress(this.crossAppOriginalLength, this.crossAppCompressedLength, this.compressedCrossAppResolutionInfo);
    }

    public void setCrossAppResolutionInfo(UnresolvedBackendCallInfo[] crossAppResolutionInfo) {
        this.crossAppResolutionInfo = crossAppResolutionInfo;
    }

    @JsonIgnore
    public void setCompressedCrossAppResolutionInfo(CompressedObject compressedInfo) {
        if (compressedInfo == null) {
            return;
        }
        this.setCrossAppOriginalLength(compressedInfo.getOriginalLength());
        this.setCrossAppCompressedLength(compressedInfo.getCompressedLength());
        this.setCompressedCrossAppResolutionInfo(compressedInfo.getCompressedBytes());
    }

    public byte[] getCompressedCrossAppResolutionInfo() {
        return this.compressedCrossAppResolutionInfo;
    }

    public void setCompressedCrossAppResolutionInfo(byte[] compressedCrossAppResolutionInfo) {
        this.compressedCrossAppResolutionInfo = compressedCrossAppResolutionInfo;
    }

    public int getCrossAppOriginalLength() {
        return this.crossAppOriginalLength;
    }

    public void setCrossAppOriginalLength(int crossAppOriginalLength) {
        this.crossAppOriginalLength = crossAppOriginalLength;
    }

    public int getCrossAppCompressedLength() {
        return this.crossAppCompressedLength;
    }

    public void setCrossAppCompressedLength(int crossAppCompressedLength) {
        this.crossAppCompressedLength = crossAppCompressedLength;
    }

    public String toString() {
        UnresolvedBackendCallInfo[] crossAppResInfo;
        StringBuilder builder = new StringBuilder();
        builder.append("ExitCallInfo {");
        UnresolvedBackendCallInfo[] resInfo = this.getResolutionInfo();
        if (resInfo != null) {
            builder.append("resolutionInfo (backend id, component id, resolution info)={");
            for (UnresolvedBackendCallInfo callInfo : resInfo) {
                builder.append('(').append(callInfo.getId()).append(',').append(callInfo.getApplicationComponentId()).append(',').append(callInfo.getResolutionInfo()).append(") ");
            }
            builder.append('}');
        }
        if ((crossAppResInfo = this.getCrossAppResolutionInfo()) != null) {
            builder.append("cross-app resolutionInfo (backend id, destination application id, resolution info)={");
            for (UnresolvedBackendCallInfo callInfo : crossAppResInfo) {
                builder.append('(').append(callInfo.getId()).append(',').append(callInfo.getDestinationApplicationId()).append(',').append(callInfo.getResolutionInfo()).append(") ");
            }
            builder.append('}');
        }
        if (this.originalLength > 0) {
            builder.append(", originalLength=").append(this.originalLength);
            builder.append(", compressedLength=").append(this.compressedLength);
        }
        if (this.crossAppOriginalLength > 0) {
            builder.append(", crossAppOriginalLength=").append(this.crossAppOriginalLength);
            builder.append(", crossAppCompressedLength=").append(this.crossAppCompressedLength);
        }
        builder.append('}');
        return builder.toString();
    }
}

