/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.AAppComponentConfigObject;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointType;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeStringHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ExcludeRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MatchPointDiscoveryConfig;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TransactionMatchPointConfig
extends AAppComponentConfigObject {
    private static final long serialVersionUID = -2782128459738364015L;
    private boolean enabled;
    private MatchPointDiscoveryConfig discoveryConfig;
    private TransactionEntryPointType entryPointType;
    private Object customDefinitions = new ArrayList();
    private String entryPointTypeString;
    @IgnoreProtoGen
    private EntityDefinition attachedEntity;
    @IgnoreProtoGen
    private AgentType agentType;

    public TransactionMatchPointConfig() {
    }

    public TransactionMatchPointConfig(boolean enabled, MatchPointDiscoveryConfig discoveryConfig, Set<CustomMatchPointDefinition> customTransactions) {
        this.enabled = enabled;
        this.discoveryConfig = discoveryConfig;
        this.customDefinitions = this.sortByPriority(customTransactions);
    }

    public void updateCustomMatchPointDefinition(CustomMatchPointDefinition customMPD) {
        ArrayList<CustomMatchPointDefinition> _customDefinitions = this.getCustomMatchPointDefinitionsAsArrayList();
        for (int i = 0; i < _customDefinitions.size(); ++i) {
            if (customMPD.getId() != ((CustomMatchPointDefinition)_customDefinitions.get(i)).getId()) continue;
            _customDefinitions.set(i, customMPD);
        }
    }

    @JsonIgnore
    public ArrayList<CustomMatchPointDefinition> getCustomMatchPointDefinitionsAsArrayList() {
        return (ArrayList)this.customDefinitions;
    }

    public boolean deleteCustomMatchPointDefinitions(long[] ids) {
        boolean deletedAll = false;
        for (int i = 0; i < ids.length; ++i) {
            deletedAll &= this.deleteCustomMatchPointDefinitions(ids[i]);
        }
        return deletedAll;
    }

    public boolean deleteCustomMatchPointDefinitions(long id) {
        ArrayList<CustomMatchPointDefinition> _customDefinitions = this.getCustomMatchPointDefinitionsAsArrayList();
        for (int i = 0; i < _customDefinitions.size(); ++i) {
            CustomMatchPointDefinition def = _customDefinitions.get(i);
            if (def.getId() != id) continue;
            CollectionHelper.removeAt(_customDefinitions, i);
            return true;
        }
        return false;
    }

    public CustomMatchPointDefinition getCustomMatchPointDefinitions(long id) {
        ArrayList<CustomMatchPointDefinition> _customDefinitions = this.getCustomMatchPointDefinitionsAsArrayList();
        for (int i = 0; i < _customDefinitions.size(); ++i) {
            CustomMatchPointDefinition def = (CustomMatchPointDefinition)_customDefinitions.get(i);
            if (def.getId() != id) continue;
            return def;
        }
        return null;
    }

    public TransactionMatchPointConfig toDTO() {
        TransactionMatchPointConfig dto = new TransactionMatchPointConfig();
        dto.setEnabled(this.enabled);
        dto.setAgentType(this.agentType);
        dto.setEntryPointTypeString(this.entryPointTypeString);
        dto.setAttachedEntity(this.attachedEntity);
        dto.setDiscoveryConfig(this.discoveryConfig);
        ArrayList<CustomMatchPointDefinition> defs = this.getCustomMatchPointDefinitionsAsArrayList();
        if (null != defs) {
            ArrayList<CustomMatchPointDefinition> newDefs = new ArrayList<CustomMatchPointDefinition>(defs.size());
            for (int i = 0; i < defs.size(); ++i) {
                newDefs.add(((CustomMatchPointDefinition)defs.get(i)).toDTO());
            }
            dto.setCustomDefinitions(newDefs);
        }
        return dto;
    }

    private ArrayList<CustomMatchPointDefinition> sortByPriority(Set<CustomMatchPointDefinition> customTransactions) {
        if (customTransactions == null) {
            return new ArrayList<CustomMatchPointDefinition>();
        }
        ArrayList<CustomMatchPointDefinition> sortedList = new ArrayList<CustomMatchPointDefinition>(customTransactions);
        CollectionHelper.sort(sortedList, new CustomMatchPointDefinitionComparator());
        return sortedList;
    }

    public void deepCopy(TransactionMatchPointConfig dto) {
        super.deepCopy(dto);
        this.setApplicationComponentId(0L);
        dto.setEnabled(this.enabled);
        dto.setEntryPointTypeString(this.entryPointTypeString);
        MatchPointDiscoveryConfig config = this.getDiscoveryConfig();
        for (ExcludeRule rule : config.getExcludes()) {
            rule.setId(0L);
        }
        dto.setDiscoveryConfig(config);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TransactionEntryPointType getEntryPointType() {
        return this.entryPointType;
    }

    public void setEntryPointType(TransactionEntryPointType entryPointType) {
        this.entryPointType = entryPointType;
    }

    public String getEntryPointTypeString() {
        if (this.entryPointTypeString == null && this.entryPointType != null) {
            return TransactionEntryPointTypeStringHelper.getString(this.entryPointType);
        }
        return this.entryPointTypeString;
    }

    public void setEntryPointTypeString(String entryPointTypeString) {
        if (TransactionEntryPointTypeHelper.isLegacyType(entryPointTypeString)) {
            this.entryPointType = TransactionEntryPointTypeStringHelper.getEnum(entryPointTypeString);
        }
        this.entryPointTypeString = entryPointTypeString;
    }

    public MatchPointDiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public void setDiscoveryConfig(MatchPointDiscoveryConfig discoveryConfig) {
        this.discoveryConfig = discoveryConfig;
    }

    public Object getCustomDefinitions() {
        return this.customDefinitions;
    }

    public void addCustomMatchPointDefinition(CustomMatchPointDefinition definition) {
        ArrayList<CustomMatchPointDefinition> _customDefinitions = this.getCustomMatchPointDefinitionsAsArrayList();
        _customDefinitions.add(definition);
    }

    public void setCustomDefinitions(List<CustomMatchPointDefinition> customDefinitions) {
        this.customDefinitions = customDefinitions;
    }

    public EntityDefinition getAttachedEntity() {
        return this.attachedEntity;
    }

    public void setAttachedEntity(EntityDefinition attachedEntity) {
        this.attachedEntity = attachedEntity;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public void setAgentType(AgentType agentType) {
        this.agentType = agentType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransactionMatchPointConfig that = (TransactionMatchPointConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.discoveryConfig != null ? !this.discoveryConfig.equals(that.discoveryConfig) : that.discoveryConfig != null) {
            return false;
        }
        if (this.entryPointType != that.entryPointType) {
            return false;
        }
        if (this.customDefinitions != null ? !this.customDefinitions.equals(that.customDefinitions) : that.customDefinitions != null) {
            return false;
        }
        if (this.entryPointTypeString != null ? !this.entryPointTypeString.equals(that.entryPointTypeString) : that.entryPointTypeString != null) {
            return false;
        }
        if (this.attachedEntity != null ? !this.attachedEntity.equals(that.attachedEntity) : that.attachedEntity != null) {
            return false;
        }
        return this.agentType == that.agentType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.discoveryConfig != null ? this.discoveryConfig.hashCode() : 0);
        result = 31 * result + (this.entryPointType != null ? this.entryPointType.hashCode() : 0);
        result = 31 * result + (this.customDefinitions != null ? this.customDefinitions.hashCode() : 0);
        result = 31 * result + (this.entryPointTypeString != null ? this.entryPointTypeString.hashCode() : 0);
        result = 31 * result + (this.attachedEntity != null ? this.attachedEntity.hashCode() : 0);
        result = 31 * result + (this.agentType != null ? this.agentType.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "TransactionMatchPointConfig{enabled=" + this.enabled + ", discoveryConfig=" + this.discoveryConfig + ", entryPointType=" + (Object)((Object)this.entryPointType) + ", customDefinitions=" + this.customDefinitions + ", entryPointTypeString='" + this.entryPointTypeString + '\'' + ", attachedEntity=" + this.attachedEntity + ", agentType=" + (Object)((Object)this.agentType) + '}';
    }

    public static class CustomMatchPointDefinitionComparator
    implements Comparator<CustomMatchPointDefinition> {
        @Override
        public int compare(CustomMatchPointDefinition def1, CustomMatchPointDefinition def2) {
            return def2.getMatchPointRule().getPriority() - def1.getMatchPointRule().getPriority();
        }
    }
}

