/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionExitPointTypeHelper;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TransactionExitPointCall {
    private String exitPointType;
    private long customExitPointDefinitionId;
    private boolean customExitPoint;
    private boolean synchronous = true;

    public TransactionExitPointCall(String exitPointType) {
        this.exitPointType = exitPointType;
        this.customExitPoint = false;
        this.synchronous = TransactionExitPointTypeHelper.isSynchronous(exitPointType);
    }

    public TransactionExitPointCall(long customExitPointDefinitionId) {
        this.customExitPointDefinitionId = customExitPointDefinitionId;
        this.customExitPoint = true;
        this.synchronous = true;
    }

    public TransactionExitPointCall() {
    }

    public TransactionExitPointCall copy() {
        TransactionExitPointCall copy = new TransactionExitPointCall();
        copy.setExitPointType(this.getExitPointType());
        copy.setCustomExitPointDefinitionId(this.getCustomExitPointDefinitionId());
        copy.setCustomExitPoint(this.isCustomExitPoint());
        copy.setSynchronous(this.isSynchronous());
        return copy;
    }

    public String getExitPointType() {
        return this.exitPointType;
    }

    public void setExitPointType(String exitPointType) {
        this.exitPointType = exitPointType;
    }

    public long getCustomExitPointDefinitionId() {
        return this.customExitPointDefinitionId;
    }

    public void setCustomExitPointDefinitionId(long customExitPointDefinitionId) {
        this.customExitPointDefinitionId = customExitPointDefinitionId;
    }

    public boolean isCustomExitPoint() {
        return this.customExitPoint;
    }

    public void setCustomExitPoint(boolean customExitPoint) {
        this.customExitPoint = customExitPoint;
    }

    public String toString() {
        return this.customExitPoint ? String.valueOf(this.customExitPointDefinitionId) : this.exitPointType;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public int hashCode() {
        Object obj = this.exitPointType;
        if (this.customExitPoint) {
            obj = this.customExitPointDefinitionId;
        }
        return APersistentObject.calculateHashCode(obj);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionExitPointCall)) {
            return false;
        }
        TransactionExitPointCall exitPoint = (TransactionExitPointCall)obj;
        if (exitPoint.customExitPoint != this.customExitPoint) {
            return false;
        }
        if (this.customExitPoint) {
            return this.customExitPointDefinitionId == exitPoint.customExitPointDefinitionId;
        }
        return this.exitPointType.equals(exitPoint.exitPointType);
    }
}

