/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.PercentileConfiguration;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.StallConfiguration;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.RequestThreshold;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ThresholdEvaluationType;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class BTRequestThresholds
extends APersistentObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private RequestThreshold startingNodeSlowThreshold;
    @FieldPosition(value=3)
    private RequestThreshold startingNodeExtremelySlowThreshold;
    @FieldPosition(value=4)
    private RequestThreshold exitCallSlowThreshold;
    @FieldPosition(value=5)
    private RequestThreshold continuingSegmentSlowThreshold;
    @FieldPosition(value=6)
    private StallConfiguration stallConfig;
    @FieldPosition(value=7)
    private PercentileConfiguration percentileConfig;

    public RequestThreshold getStartingNodeSlowThreshold() {
        return this.startingNodeSlowThreshold;
    }

    public void setStartingNodeSlowThreshold(RequestThreshold startingNodeSlowThreshold) {
        this.startingNodeSlowThreshold = startingNodeSlowThreshold;
    }

    public RequestThreshold getExitCallSlowThreshold() {
        return this.exitCallSlowThreshold;
    }

    public void setExitCallSlowThreshold(RequestThreshold exitCallSlowThreshold) {
        this.exitCallSlowThreshold = exitCallSlowThreshold;
    }

    public RequestThreshold getContinuingSegmentSlowThreshold() {
        return this.continuingSegmentSlowThreshold;
    }

    public void setContinuingSegmentSlowThreshold(RequestThreshold continuingSegmentSlowThreshold) {
        this.continuingSegmentSlowThreshold = continuingSegmentSlowThreshold;
    }

    public void setStartingNodeExtremelySlowThreshold(RequestThreshold startingNodeExtremelySlowThreshold) {
        this.startingNodeExtremelySlowThreshold = startingNodeExtremelySlowThreshold;
    }

    public RequestThreshold getStartingNodeExtremelySlowThreshold() {
        return this.startingNodeExtremelySlowThreshold;
    }

    public StallConfiguration getStallConfig() {
        return this.stallConfig;
    }

    public void setStallConfig(StallConfiguration stallConfig) {
        this.stallConfig = stallConfig;
    }

    public PercentileConfiguration getPercentileConfig() {
        return this.percentileConfig;
    }

    public void setPercentileConfig(PercentileConfiguration config) {
        this.percentileConfig = config;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Starting Node Slow Threshold [").append(" Standard Deviation [").append(this.getStartingNodeSlowThreshold().getStandardDeviationThreshold()).append("] Static Threshold [").append(this.getStartingNodeSlowThreshold().getStaticThresholdInMillis()).append("] ] ");
        sb.append("Starting Node Extremely Slow Threshold [").append(" Standard Deviation [").append(this.getStartingNodeExtremelySlowThreshold().getStandardDeviationThreshold()).append("] Static Threshold [").append(this.getStartingNodeExtremelySlowThreshold().getStaticThresholdInMillis()).append("] ] ");
        sb.append("Continuing Segment Slow Threshold [").append(" Standard Deviation [").append(this.getContinuingSegmentSlowThreshold().getStandardDeviationThreshold()).append("] Static Threshold [").append(this.getContinuingSegmentSlowThreshold().getStaticThresholdInMillis()).append("] ] ");
        sb.append(this.stallConfig);
        sb.append(" ").append(this.percentileConfig);
        return sb.toString();
    }

    public static BTRequestThresholds getDefaultThresholds() {
        BTRequestThresholds thresholds = new BTRequestThresholds();
        RequestThreshold slowThreshold = new RequestThreshold();
        slowThreshold.setEvaluationType(ThresholdEvaluationType.STANDARD_DEVIATION);
        slowThreshold.setStandardDeviationThreshold(3.0f);
        slowThreshold.setPercentageThresholdEvaluationMinutes(120);
        thresholds.setStartingNodeSlowThreshold(slowThreshold);
        RequestThreshold verySlowThreshold = new RequestThreshold();
        verySlowThreshold.setEvaluationType(ThresholdEvaluationType.STANDARD_DEVIATION);
        verySlowThreshold.setStandardDeviationThreshold(4.0f);
        verySlowThreshold.setPercentageThresholdEvaluationMinutes(120);
        thresholds.setStartingNodeExtremelySlowThreshold(verySlowThreshold);
        thresholds.setContinuingSegmentSlowThreshold(slowThreshold);
        thresholds.setExitCallSlowThreshold(slowThreshold);
        thresholds.setStallConfig(StallConfiguration.getDefaultStallConfiguration());
        thresholds.setPercentileConfig(PercentileConfiguration.getDefaultPercentileConfiguration());
        return thresholds;
    }
}

