/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotExitCall;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionSnapshotData;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.ArrayList;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TransactionSnapshot
extends APersistentObject
implements SingularitySerializable {
    private static final long serialVersionUID = 1L;
    private String snapshotGuid;
    private String sessionGuid;
    private long applicationNodeId;
    private long applicationComponentId;
    private long businessTransactionId;
    private long startTime;
    private int timeTakenInMilliSecs;
    private boolean firstInChain;
    private String callChain;
    private boolean errorOccured;
    private String errorDetail;
    private NameValuePair[] transactionProperties;
    private String snapshotExitSequence;
    private SnapshotExitCall[] snapshotExitCalls;
    private TransactionSnapshotData data;
    private String reason;
    private String policy;
    private int localID;
    private boolean exitCallsDataTruncated;
    private String exitCallsDataTruncationMessage;
    private boolean delayedSnapshot;
    private int offsetFromStart;

    public boolean validate() {
        if (this.timeTakenInMilliSecs < 0) {
            throw new IllegalArgumentException("Negative value for 'timeTakenInMillis' for Snapshot: " + this);
        }
        if (this.offsetFromStart < 0) {
            throw new IllegalArgumentException("Negative value for 'OffsetFromStart' for Snapshot: " + this);
        }
        for (SnapshotExitCall exitcall : this.snapshotExitCalls) {
            if (exitcall.getTimeTakenInMillis() < 0) {
                throw new IllegalArgumentException("Negative value for 'timeTakenInMillis' for Snapshot exit call: " + this);
            }
            if (exitcall.getErrorCount() >= 0) continue;
            throw new IllegalArgumentException("Negative value for 'ErrorCount' for Snapshot exit call: " + this);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("id:").append(this.getId()).append(" guid:").append(this.snapshotGuid).append(" bt:").append(this.businessTransactionId).append(" component:").append(this.applicationComponentId).append(" node").append(this.applicationNodeId).append(" timeTaken:").append(this.timeTakenInMilliSecs).append(" callChain:").append(this.callChain).append(" seq:").append(this.snapshotExitSequence).append(" data:" + this.data);
        if (this.snapshotExitCalls != null) {
            for (SnapshotExitCall exitCall : this.snapshotExitCalls) {
                sb.append("\n").append(exitCall);
            }
        }
        return sb.toString();
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isExitCallsDataTruncated() {
        return this.exitCallsDataTruncated;
    }

    public void setExitCallsDataTruncated(boolean exitCallsDataTruncated) {
        this.exitCallsDataTruncated = exitCallsDataTruncated;
    }

    public String getExitCallsDataTruncationMessage() {
        return this.exitCallsDataTruncationMessage;
    }

    public void setExitCallsDataTruncationMessage(String exitCallsDataTruncationMessage) {
        this.exitCallsDataTruncationMessage = exitCallsDataTruncationMessage;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(boolean firstInChain) {
        this.firstInChain = firstInChain;
    }

    public String getSnapshotGuid() {
        return this.snapshotGuid;
    }

    public void setSnapshotGuid(String snapshotGuid) {
        this.snapshotGuid = snapshotGuid;
    }

    public String getSessionGuid() {
        return this.sessionGuid;
    }

    public void setSessionGuid(String sessionGuid) {
        this.sessionGuid = sessionGuid;
    }

    public long getApplicationNodeId() {
        return this.applicationNodeId;
    }

    public void setApplicationNodeId(long applicationNodeId) {
        this.applicationNodeId = applicationNodeId;
    }

    public long getBusinessTransactionId() {
        return this.businessTransactionId;
    }

    public void setBusinessTransactionId(long businessTransactionId) {
        this.businessTransactionId = businessTransactionId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getTimeTakenInMilliSecs() {
        return this.timeTakenInMilliSecs;
    }

    public void setTimeTakenInMilliSecs(int timeTakenInMilliSecs) {
        this.timeTakenInMilliSecs = timeTakenInMilliSecs;
    }

    public TransactionSnapshotData getData() {
        return this.data;
    }

    public void setData(TransactionSnapshotData data) {
        this.data = data;
    }

    public String getCallChain() {
        return this.callChain;
    }

    public void setCallChain(String callChain) {
        this.callChain = callChain;
    }

    public String getSnapshotExitSequence() {
        return this.snapshotExitSequence;
    }

    public void setSnapshotExitSequence(String snapshotExitSequence) {
        this.snapshotExitSequence = snapshotExitSequence;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public SnapshotExitCall[] getSnapshotExitCalls() {
        return this.snapshotExitCalls;
    }

    public void setSnapshotExitCalls(SnapshotExitCall[] snapshotExitCalls) {
        this.snapshotExitCalls = snapshotExitCalls;
    }

    public long getApplicationComponentId() {
        return this.applicationComponentId;
    }

    public void setApplicationComponentId(long applicationComponentId) {
        this.applicationComponentId = applicationComponentId;
    }

    public String getTransactionPropertiesAsString() {
        String propStr = "";
        if (this.getTransactionProperties() != null) {
            for (NameValuePair pair : this.getTransactionProperties()) {
                propStr = propStr + pair.getName() + ":" + pair.getValue() + ";";
            }
        }
        return propStr;
    }

    public void setTransactionPropertiesFromString(String propStr) {
        String[] propStrs;
        if (propStr == null || propStr.trim().length() == 0) {
            this.setTransactionProperties(new NameValuePair[0]);
            return;
        }
        ArrayList<NameValuePair> pairList = new ArrayList<NameValuePair>();
        for (String keyVal : propStrs = StringRegexOperations.split(propStr, ";")) {
            String[] keyVals = StringRegexOperations.split(keyVal, ":");
            NameValuePair pair = new NameValuePair();
            pair.setName(keyVals[0]);
            if (keyVals.length == 1) {
                pair.setValue("");
            } else {
                pair.setValue(keyVals[1]);
            }
            pairList.add(pair);
        }
        NameValuePair[] props = CollectionHelper.collectionToArray(pairList, new NameValuePair[pairList.size()]);
        this.setTransactionProperties(props);
    }

    public NameValuePair[] getTransactionProperties() {
        return this.transactionProperties;
    }

    public void setTransactionProperties(NameValuePair[] transactionProperties) {
        this.transactionProperties = transactionProperties;
    }

    public int getLocalID() {
        return this.localID;
    }

    public void setLocalID(int localID) {
        this.localID = localID;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public boolean isDelayedSnapshot() {
        return this.delayedSnapshot;
    }

    public void setDelayedSnapshot(boolean delayedSnapshot) {
        this.delayedSnapshot = delayedSnapshot;
    }

    public int getOffsetFromStart() {
        return this.offsetFromStart;
    }

    public void setOffsetFromStart(int offsetFromStart) {
        this.offsetFromStart = offsetFromStart;
    }
}

