/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeHelperLanguageSpecific;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.version.AgentVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TSCodeGen(exclude=true)
public class TransactionEntryPointTypeHelper {
    private static final Map<String, TypeFields> entryPointTypeToFields;
    public static final String JAVA_AGENT = "javaAgent";
    public static final String DOT_NET_AGENT = "dotNetAgent";
    public static final String PHP_AGENT = "phpAgent";
    public static final String NODEJS_AGENT = "nodeJsAgent";
    public static final String OLD_NATIVE_AGENT = "oldNativeAgent";
    public static final String NATIVE_AGENT = "nativeAgent";
    public static final String PYTHON_AGENT = "pythonAgent";
    public static final String RUBY_AGENT = "rubyAgent";

    private TransactionEntryPointTypeHelper() {
    }

    public static Set<String> getTransactionEntryPointTypes() {
        return CollectionHelper.getAllKeys(entryPointTypeToFields);
    }

    public static int getNumberOfTransactionEntryPointTypes() {
        return CollectionHelper.getAllKeys(entryPointTypeToFields).size();
    }

    public static String getDefaultLegacyType() {
        return TransactionEntryPointTypeHelperLanguageSpecific.getDefaultLegacyType();
    }

    public static boolean isAutoDiscoveryEnabled(String entryPointType) {
        if (entryPointTypeToFields.containsKey(entryPointType)) {
            return TransactionEntryPointTypeHelper.entryPointTypeToFields.get((Object)entryPointType).isAutoDiscoveryEnabled;
        }
        return false;
    }

    public static boolean isLegacyType(String entryPointType) {
        if (entryPointTypeToFields.containsKey(entryPointType)) {
            return TransactionEntryPointTypeHelper.entryPointTypeToFields.get((Object)entryPointType).isLegacyType;
        }
        return false;
    }

    public static boolean isValidType(String entryPointType) {
        return entryPointTypeToFields.containsKey(entryPointType);
    }

    public static Set<AgentType> getRelevantAgentRuntimes(String entryPointType) {
        if (entryPointTypeToFields.containsKey(entryPointType)) {
            return CollectionHelper.unmodifiableSet(TransactionEntryPointTypeHelper.entryPointTypeToFields.get((Object)entryPointType).relevantAgentTypes);
        }
        return null;
    }

    public static AgentVersion getSupportedVersion(String entryPointType) {
        if (entryPointTypeToFields.containsKey(entryPointType)) {
            return TransactionEntryPointTypeHelper.entryPointTypeToFields.get((Object)entryPointType).supportedVersion;
        }
        return null;
    }

    public static String getEntryPointTypeForDefaultTransaction(AgentType agentType) {
        String transactionEntryPointTypeString = null;
        switch (agentType) {
            case APP_AGENT: {
                transactionEntryPointTypeString = "POJO";
                break;
            }
            case DOT_NET_APP_AGENT: {
                transactionEntryPointTypeString = "POCO";
                break;
            }
            case PHP_APP_AGENT: {
                transactionEntryPointTypeString = "PHP_CLI";
                break;
            }
            case NODEJS_APP_AGENT: {
                transactionEntryPointTypeString = "NODEJS_WEB";
                break;
            }
            case PYTHON_APP_AGENT: {
                transactionEntryPointTypeString = "PYTHON_WEB";
                break;
            }
            case NATIVE_APP_AGENT: {
                transactionEntryPointTypeString = "NATIVE";
                break;
            }
            case NATIVE_SDK: {
                transactionEntryPointTypeString = "NATIVE";
                break;
            }
            case NATIVE_DYNAMIC: {
                transactionEntryPointTypeString = "NATIVE";
                break;
            }
            case NATIVE_WEB_SERVER: {
                transactionEntryPointTypeString = "WEB";
                break;
            }
            case RUBY_APP_AGENT: {
                transactionEntryPointTypeString = "RUBY_RAILS";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid agentType argument: " + (Object)((Object)agentType) + " - please correct or map agent type to a default entry point type.");
            }
        }
        return transactionEntryPointTypeString;
    }

    public static boolean isSupportedVersion(String entryPointType, AgentVersion agentVersion) {
        if (entryPointTypeToFields.containsKey(entryPointType)) {
            AgentVersion supportedVersion = TransactionEntryPointTypeHelper.entryPointTypeToFields.get((Object)entryPointType).supportedVersion;
            return agentVersion.greaterOrEqualsTo(supportedVersion);
        }
        return false;
    }

    static {
        HashMap<String, Set<AgentType>> entryPointTypeToAgentTypes = new HashMap<String, Set<AgentType>>();
        HashSet<AgentType> javaAgentOnly = new HashSet<AgentType>();
        javaAgentOnly.add(AgentType.APP_AGENT);
        entryPointTypeToAgentTypes.put(JAVA_AGENT, javaAgentOnly);
        HashSet<AgentType> dotNetAgentOnly = new HashSet<AgentType>();
        dotNetAgentOnly.add(AgentType.DOT_NET_APP_AGENT);
        entryPointTypeToAgentTypes.put(DOT_NET_AGENT, dotNetAgentOnly);
        HashSet<AgentType> phpAgentOnly = new HashSet<AgentType>();
        phpAgentOnly.add(AgentType.PHP_APP_AGENT);
        entryPointTypeToAgentTypes.put(PHP_AGENT, phpAgentOnly);
        HashSet<AgentType> nodeJSAgentOnly = new HashSet<AgentType>();
        nodeJSAgentOnly.add(AgentType.NODEJS_APP_AGENT);
        entryPointTypeToAgentTypes.put(NODEJS_AGENT, nodeJSAgentOnly);
        HashSet<AgentType> oldNativeAgentOnly = new HashSet<AgentType>();
        oldNativeAgentOnly.add(AgentType.NATIVE_APP_AGENT);
        entryPointTypeToAgentTypes.put(OLD_NATIVE_AGENT, oldNativeAgentOnly);
        HashSet<AgentType> nativeAgents = new HashSet<AgentType>();
        nativeAgents.add(AgentType.NATIVE_SDK);
        nativeAgents.add(AgentType.NATIVE_DYNAMIC);
        nativeAgents.add(AgentType.NATIVE_WEB_SERVER);
        nativeAgents.add(AgentType.GOLANG_SDK);
        nativeAgents.add(AgentType.WMB_AGENT);
        entryPointTypeToAgentTypes.put(NATIVE_AGENT, nativeAgents);
        HashSet<AgentType> pythonAgentOnly = new HashSet<AgentType>();
        pythonAgentOnly.add(AgentType.PYTHON_APP_AGENT);
        entryPointTypeToAgentTypes.put(PYTHON_AGENT, pythonAgentOnly);
        HashSet<AgentType> rubyAgentOnly = new HashSet<AgentType>();
        rubyAgentOnly.add(AgentType.RUBY_APP_AGENT);
        entryPointTypeToAgentTypes.put(RUBY_AGENT, rubyAgentOnly);
        HashMap<String, TypeFields> tempEntryPointTypeToField = new HashMap<String, TypeFields>();
        TransactionEntryPointTypeHelperLanguageSpecific.setTypeFieldsFromAnnotation(tempEntryPointTypeToField, entryPointTypeToAgentTypes);
        entryPointTypeToFields = CollectionHelper.unmodifiableMap(tempEntryPointTypeToField);
    }

    public static class TypeFields {
        final boolean isAutoDiscoveryEnabled;
        final boolean isLegacyType;
        final Set<AgentType> relevantAgentTypes;
        final AgentVersion supportedVersion;

        TypeFields(boolean isAutoDiscoveryEnabled, boolean isLegacyType, Set<AgentType> relevantAgentTypes, AgentVersion supportedVersion) {
            this.isAutoDiscoveryEnabled = isAutoDiscoveryEnabled;
            this.isLegacyType = isLegacyType;
            this.relevantAgentTypes = relevantAgentTypes;
            this.supportedVersion = supportedVersion;
        }
    }
}

