/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.CallType;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallElement;
import com.singularity.ee.controller.api.dto.transactionmonitor.ResolvedCall;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotExitCall;
import java.util.HashMap;
import java.util.Map;

@IgnoreProtoGen
@UiCodeGen
@TSCodeGen(exclude=true)
public class HotspotCallGraph
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=3)
    private int[] transformationIds;
    @FieldPosition(value=4)
    private int[] startTimes;
    @FieldPosition(value=5)
    private int[] endTimes;
    @FieldPosition(value=6)
    private int dataPtr = 0;
    @Deprecated
    @FieldPosition(value=7)
    private short[] indicesStack;
    @FieldPosition(value=10)
    private SnapshotExitCall[] snapshotExitCalls = null;
    @IgnoreProtoGen
    private Object transformationIdDetails = null;

    public HotspotCallGraph() {
    }

    public HotspotCallGraph(int[] transformationIds, int[] startTimes, int[] endTimes, int dataPtr, SnapshotExitCall[] snapshotExitCalls) {
        this.transformationIds = transformationIds;
        this.startTimes = startTimes;
        this.endTimes = endTimes;
        this.dataPtr = dataPtr;
        this.snapshotExitCalls = snapshotExitCalls;
    }

    public int[] getTransformationIds() {
        return this.transformationIds;
    }

    public void setTransformationIds(int[] transformationIds) {
        this.transformationIds = transformationIds;
    }

    public int[] getStartTimes() {
        return this.startTimes;
    }

    public void setStartTimes(int[] startTimes) {
        this.startTimes = startTimes;
    }

    public int[] getEndTimes() {
        return this.endTimes;
    }

    public void setEndTimes(int[] endTimes) {
        this.endTimes = endTimes;
    }

    public int getDataPtr() {
        return this.dataPtr;
    }

    public void setDataPtr(int dataPtr) {
        this.dataPtr = dataPtr;
    }

    public SnapshotExitCall[] getSnapshotExitCalls() {
        return this.snapshotExitCalls;
    }

    @Deprecated
    public short[] getIndicesStack() {
        return this.indicesStack;
    }

    @Deprecated
    public void setIndicesStack(short[] indicesStack) {
        this.indicesStack = indicesStack;
    }

    public void setSnapshotExitCalls(SnapshotExitCall[] snapshotExitCalls) {
        this.snapshotExitCalls = snapshotExitCalls;
    }

    public Object getTransformationIdDetails() {
        return this.transformationIdDetails;
    }

    public void setTransformationIdDetails(Object transformationIdDetails) {
        this.transformationIdDetails = transformationIdDetails;
    }

    public CallElement createCallElementTree(int index) {
        int endIndex;
        if (index >= this.dataPtr) {
            return null;
        }
        CallElement callElement = new CallElement();
        callElement.setType(CallType.POJO);
        this.setClassAndMethodName(this.transformationIds[index], callElement);
        callElement.setTimeSpentInMilliSec(this.endTimes[index] - this.startTimes[index]);
        int indexWithinHotspotIndices = index * 3;
        for (SnapshotExitCall snapshotExitCall : this.snapshotExitCalls) {
            int indexAt = this.contains(snapshotExitCall.getHotspotIndices(), indexWithinHotspotIndices);
            if (indexAt < 0) continue;
            SnapshotExitCall exitCall = new SnapshotExitCall(snapshotExitCall);
            String[] errors = exitCall.getHotspotIndicesErrorDetails();
            int[] timeTaken = exitCall.getHotspotIndicesTimeTaken();
            exitCall.setTimeTakenInMillis(timeTaken[indexAt]);
            exitCall.setErrorDetails(errors[indexAt]);
            exitCall.setCount(1);
            callElement.addExitCall(exitCall);
        }
        for (endIndex = index + 1; endIndex < this.dataPtr && this.endTimes[endIndex] <= this.endTimes[index]; ++endIndex) {
        }
        int i = index + 1;
        while (i < endIndex) {
            CallElement child = this.createCallElementTree(i);
            if (child != null) {
                i = child.getLineNumber();
                child.setLineNumber(-1);
                callElement.addChild(child);
                continue;
            }
            i = this.dataPtr;
        }
        callElement.flatten();
        callElement.setLineNumber(endIndex);
        return callElement;
    }

    private int contains(short[] hotspotIndices, int index) {
        if (hotspotIndices == null) {
            return -1;
        }
        for (int i = 0; i < hotspotIndices.length; ++i) {
            if (index != hotspotIndices[i]) continue;
            return i;
        }
        return -1;
    }

    private void setClassAndMethodName(int transformationId, CallElement callElement) {
        ResolvedCall resolvedCall = (ResolvedCall)((Map)this.transformationIdDetails).get(transformationId);
        if (resolvedCall == null) {
            callElement.setClassName("UNKNOWN");
            callElement.setMethodName("UNKNOWN");
        } else {
            String[] names = resolvedCall.getCallNames();
            callElement.setClassName(resolvedCall.getFullClassName());
            if (names.length == 3) {
                callElement.setMethodName(names[2]);
            } else if (names.length == 4) {
                callElement.setMethodName(names[3]);
            } else if (names.length == 2) {
                // empty if block
            }
            callElement.setNames(resolvedCall.getCallNames());
            callElement.setType(resolvedCall.getCallType());
        }
    }

    public void addTransformationIdInfo(int transformationId, String className, String methodName, ResolvedCall resolvedCall) {
        resolvedCall.setFullClassName(className);
        if (this.transformationIdDetails == null) {
            this.transformationIdDetails = new HashMap();
        }
        ((Map)this.transformationIdDetails).put(transformationId, resolvedCall);
    }
}

