/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.CallType;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.ContentionInfo;
import com.singularity.ee.controller.api.dto.transactionmonitor.ResolvedCall;
import com.singularity.ee.controller.api.dto.transactionmonitor.ResourceDelay;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotExitCall;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class CallElement
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final SnapshotExitCall[] EMPTY_SEC_ARRAY = new SnapshotExitCall[0];
    @IgnoreProtoGen
    private static final CallElement[] EMPTY_CE_ARRAY = new CallElement[0];
    @IgnoreProtoGen
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=3)
    private CallType type;
    @FieldPosition(value=4)
    private String name;
    @FieldPosition(value=5)
    private String[] names;
    @FieldPosition(value=6)
    private String className;
    @FieldPosition(value=7)
    private String methodName;
    @FieldPosition(value=8)
    private int lineNumber;
    @FieldPosition(value=9)
    private boolean loop;
    @FieldPosition(value=10)
    private int loopCount;
    @FieldPosition(value=11)
    private int timeSpentInMilliSec;
    @FieldPosition(value=12)
    private NameValuePair[] properties;
    @FieldPosition(value=13)
    private CallElement[] children;
    @FieldPosition(value=16)
    private SnapshotExitCall[] exitCalls;
    @FieldPosition(value=17)
    private long blockTime;
    @FieldPosition(value=18)
    private long waitTime;
    @FieldPosition(value=19)
    private long[] serviceEndPointIds;
    @FieldPosition(value=20)
    private long resourceWaitTime;
    @IgnoreProtoGen
    private ContentionInfo[] lockArray;
    @IgnoreProtoGen
    private ResourceDelay[] resourceDelays;
    @IgnoreProtoGen
    private transient List<ResourceDelay> listOfResourceDelays;
    @IgnoreProtoGen
    private long cpuTime;
    @IgnoreProtoGen
    private transient ArrayList<ContentionInfo> lockList = null;
    @IgnoreProtoGen
    private transient CallElement firstChild;
    @IgnoreProtoGen
    private transient List<CallElement> childrenList = null;
    @IgnoreProtoGen
    private transient List<SnapshotExitCall> exitCallList = null;
    @IgnoreProtoGen
    private transient long startTimeInMilliSecs;
    @IgnoreProtoGen
    private transient boolean closed;
    @IgnoreProtoGen
    private transient CallElement parent = null;
    @IgnoreProtoGen
    private transient ResolvedCall resolvedCall = null;
    @IgnoreProtoGen
    private transient int numOfChildren = -1;
    @IgnoreProtoGen
    private transient List<Long> serviceEndPointIdsList;

    public void addBlockingInfo(ContentionInfo contentionInfo) {
        this.getLockList().add(contentionInfo);
    }

    public CallType getType() {
        return this.type;
    }

    public void setType(CallType type) {
        this.type = type;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public void setResolvedCall(ResolvedCall resolvedCall) {
        this.setNames(resolvedCall.getCallNames());
        this.setType(resolvedCall.getCallType());
        this.resolvedCall = resolvedCall;
    }

    public ResolvedCall getResolvedCall() {
        return this.resolvedCall;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            sb.append(this.names[i]);
        }
        return sb.toString();
    }

    public void setName(String name) {
        this.names = new String[]{name};
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getTimeSpentInMilliSec() {
        return this.timeSpentInMilliSec;
    }

    public void setTimeSpentInMilliSec(int timeSpentInMilliSec) {
        this.timeSpentInMilliSec = timeSpentInMilliSec;
    }

    public long getStartTimeInMilliSecs() {
        return this.startTimeInMilliSecs;
    }

    public void setStartTimeInMilliSecs(long startTimeInMilliSecs) {
        this.startTimeInMilliSecs = startTimeInMilliSecs;
    }

    public void setClosed() {
        if (this.lockList != null) {
            this.lockArray = this.lockList.toArray(new ContentionInfo[this.lockList.size()]);
        }
        if (this.listOfResourceDelays != null && this.listOfResourceDelays.size() > 0) {
            this.resourceDelays = CollectionHelper.collectionToArray(this.listOfResourceDelays, new ResourceDelay[this.listOfResourceDelays.size()]);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean hasContentionInfo() {
        return this.lockList != null && this.lockList.size() > 0;
    }

    public void setExitCalls(SnapshotExitCall[] exitCalls) {
        this.exitCalls = exitCalls;
    }

    public SnapshotExitCall[] getExitCalls() {
        return this.exitCalls;
    }

    public String toString() {
        return this.className + ":" + this.methodName;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public NameValuePair[] getProperties() {
        return this.properties;
    }

    public void setProperties(NameValuePair[] properties) {
        this.properties = properties;
    }

    public CallElement getParent() {
        return this.parent;
    }

    public CallElement[] getChildren() {
        if (this.children == null) {
            return EMPTY_CE_ARRAY;
        }
        return this.children;
    }

    public void setChildren(CallElement[] children) {
        this.children = children;
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                children[i].parent = this;
            }
        }
    }

    public void flatten() {
        if (this.exitCallList != null) {
            this.exitCalls = CollectionHelper.collectionToArray(this.exitCallList, new SnapshotExitCall[this.exitCallList.size()]);
            this.exitCallList = null;
        } else {
            this.exitCalls = EMPTY_SEC_ARRAY;
        }
        if (this.firstChild != null) {
            this.children = new CallElement[]{this.firstChild};
            this.firstChild = null;
        } else if (this.childrenList != null) {
            this.children = CollectionHelper.collectionToArray(this.childrenList, new CallElement[this.childrenList.size()]);
            this.childrenList = null;
        } else {
            this.children = EMPTY_CE_ARRAY;
        }
        this.serviceEndPointIds = null != this.serviceEndPointIdsList && this.serviceEndPointIdsList.size() > 0 ? CollectionHelper.collectionToLongArray(this.serviceEndPointIdsList) : EMPTY_LONG_ARRAY;
    }

    public void addExitCall(SnapshotExitCall exitCall) {
        if (this.exitCalls != null) {
            return;
        }
        if (this.exitCallList == null) {
            this.exitCallList = new ArrayList<SnapshotExitCall>(2);
        }
        exitCall.setCallElement(this);
        this.exitCallList.add(exitCall);
    }

    public void removeExitCall(SnapshotExitCall exitCallToRemove, ILogger logger) {
        if (null != this.exitCalls) {
            SnapshotExitCall[] validExitCalls = new SnapshotExitCall[this.exitCalls.length - 1];
            int i = 0;
            int j = 0;
            while (i < this.exitCalls.length) {
                if (this.exitCalls[i] != exitCallToRemove) {
                    validExitCalls[j++] = this.exitCalls[i++];
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing async call at [" + exitCallToRemove.getCallingMethod() + "] from Snapshot");
                }
                ++i;
            }
            this.exitCalls = validExitCalls;
        }
    }

    public void addChild(CallElement child) {
        if (this.children != null) {
            return;
        }
        if (child != null) {
            child.parent = this;
        }
        if (this.firstChild == null && this.childrenList == null) {
            this.firstChild = child;
            return;
        }
        if (this.firstChild != null && this.childrenList == null) {
            this.childrenList = new ArrayList<CallElement>(4);
            this.childrenList.add(this.firstChild);
            this.firstChild = null;
        }
        this.childrenList.add(child);
    }

    public CallElement getLastChild() {
        if (this.children != null) {
            return this.children.length == 0 ? null : this.children[this.children.length - 1];
        }
        if (this.firstChild != null) {
            return this.firstChild;
        }
        if (this.childrenList != null) {
            return this.childrenList.isEmpty() ? null : this.childrenList.get(this.childrenList.size() - 1);
        }
        return null;
    }

    public int getChildCount() {
        if (this.children != null) {
            return this.children.length;
        }
        if (this.firstChild != null) {
            return 1;
        }
        if (this.childrenList != null) {
            return this.childrenList.size();
        }
        return 0;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    public long getResourceWaitTime() {
        return this.resourceWaitTime;
    }

    public void setResourceWaitTime(long resourceWaitTime) {
        this.resourceWaitTime = resourceWaitTime;
    }

    public int getNumOfChildren() {
        return this.numOfChildren;
    }

    public void setNumOfChildren(int numOfChildren) {
        this.numOfChildren = numOfChildren;
    }

    public List<CallElement> getChildrenListForDebug() {
        if (this.children != null) {
            return CollectionHelper.asList(this.children);
        }
        if (this.firstChild != null) {
            ArrayList<CallElement> list = new ArrayList<CallElement>(1);
            list.add(this.firstChild);
            return list;
        }
        if (this.childrenList != null) {
            return this.childrenList;
        }
        return CollectionHelper.emptySerializableList();
    }

    public void addServiceEndPointId(long serviceEndPointId) {
        if (null == this.serviceEndPointIdsList) {
            this.serviceEndPointIdsList = new ArrayList<Long>(4);
        }
        this.serviceEndPointIdsList.add(serviceEndPointId);
    }

    public List<Long> getServiceEndPointIdsList() {
        return this.serviceEndPointIdsList;
    }

    public ContentionInfo[] getLockArray() {
        return this.lockArray;
    }

    public void setLockArray(ContentionInfo[] lockArray) {
        throw new UnsupportedOperationException("Setting lock array not supported");
    }

    public void setResourceDelays(ResourceDelay[] resourceDelays) {
        throw new UnsupportedOperationException("Setting resource delays not supported");
    }

    public void setServiceEndPointIdsList(List<Long> serviceEndPointIdsList) {
        this.serviceEndPointIdsList = serviceEndPointIdsList;
    }

    public long[] getServiceEndPointIds() {
        return this.serviceEndPointIds;
    }

    public void setServiceEndPointIds(long[] serviceEndPointIds) {
        this.serviceEndPointIds = serviceEndPointIds;
    }

    public ArrayList<ContentionInfo> getLockList() {
        if (this.lockList == null) {
            this.lockList = new ArrayList();
        }
        return this.lockList;
    }

    public ResourceDelay[] getResourceDelays() {
        return this.resourceDelays;
    }

    public List<ResourceDelay> getListOfResourceDelays() {
        return this.listOfResourceDelays;
    }

    public void setListOfResourceDelays(List<ResourceDelay> listOfResourceDelays) {
        this.listOfResourceDelays = listOfResourceDelays;
    }

    public void reset() {
        this.type = null;
        this.name = null;
        this.names = null;
        this.className = null;
        this.methodName = null;
        this.lineNumber = 0;
        this.loop = false;
        this.loopCount = 0;
        this.timeSpentInMilliSec = 0;
        this.properties = null;
        this.children = null;
        this.firstChild = null;
        this.childrenList = null;
        this.exitCalls = null;
        this.exitCallList = null;
        this.startTimeInMilliSecs = 0L;
        this.resourceWaitTime = 0L;
        this.closed = false;
        this.parent = null;
        this.serviceEndPointIds = null;
        this.serviceEndPointIdsList = null;
        if (this.lockList != null) {
            this.lockList.clear();
        }
        this.lockArray = null;
        this.resourceDelays = null;
        this.listOfResourceDelays = null;
    }

    public CallElement deepCopy() {
        CallElement copy = new CallElement();
        copy.setType(this.getType());
        copy.setNames(this.getNames() != null ? (String[])this.getNames().clone() : null);
        copy.setClassName(this.getClassName());
        copy.setMethodName(this.getMethodName());
        copy.setLineNumber(this.getLineNumber());
        copy.setLoop(this.isLoop());
        copy.setLoopCount(this.getLoopCount());
        copy.setTimeSpentInMilliSec(this.getTimeSpentInMilliSec());
        copy.setProperties(this.getProperties() != null ? (NameValuePair[])this.getProperties().clone() : null);
        if (this.getChildren() != null) {
            CallElement[] childrenCopy = new CallElement[this.getChildren().length];
            for (int i = 0; i < this.getChildren().length; ++i) {
                if (this.getChildren()[i] == null) continue;
                childrenCopy[i] = this.getChildren()[i].deepCopy();
            }
            copy.setChildren(childrenCopy);
        }
        copy.setBlockTime(this.getBlockTime());
        copy.setWaitTime(this.getWaitTime());
        copy.setCpuTime(this.getCpuTime());
        copy.setResourceWaitTime(this.getResourceWaitTime());
        if (this.getServiceEndPointIds() != null) {
            copy.setServiceEndPointIds((long[])this.getServiceEndPointIds().clone());
        }
        return copy;
    }
}

