/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.thousandeyes.adql;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UiCodeGen
@TSCodeGen(exclude=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryResponse {
    private static final String APP_KEY_APP_NAME_SEPARATOR = "~";
    List<List<String>> results;
    private int total;

    public Map<String, Set<String>> getDomainsForAppKeys() {
        if (this.results == null || this.results.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> appKeyDomainsMap = new HashMap<String, Set<String>>();
        for (List<String> innerList : this.results) {
            if (innerList == null || innerList.isEmpty()) continue;
            String domain = innerList.get(1);
            String appKey = innerList.get(0);
            if (domain == null) continue;
            if (appKeyDomainsMap.containsKey(appKey)) {
                ((Set)appKeyDomainsMap.get(appKey)).add(domain);
                continue;
            }
            appKeyDomainsMap.put(appKey, new HashSet<String>(Arrays.asList(domain)));
        }
        return appKeyDomainsMap;
    }

    public Map<String, Set<String>> getMobileDomainsForAppKeys() {
        if (this.results == null || this.results.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> appKeyDomainsMap = new HashMap<String, Set<String>>();
        for (List<String> innerList : this.results) {
            if (innerList == null || innerList.size() < 3) continue;
            String appKey = innerList.get(0);
            String mobileAppName = innerList.get(1);
            String domain = innerList.get(2);
            if (domain == null || mobileAppName == null) continue;
            String uniqueAppKeyForAppName = appKey + APP_KEY_APP_NAME_SEPARATOR + mobileAppName;
            HashSet<String> domainSet = (HashSet<String>)appKeyDomainsMap.get(uniqueAppKeyForAppName);
            if (domainSet == null) {
                domainSet = new HashSet<String>();
                appKeyDomainsMap.put(uniqueAppKeyForAppName, domainSet);
            }
            domainSet.add(domain);
        }
        return appKeyDomainsMap;
    }

    public List<List<String>> getResults() {
        return this.results;
    }

    public int getTotal() {
        return this.total;
    }

    public void setResults(List<List<String>> results) {
        this.results = results;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<List<String>> this$results = this.getResults();
        List<List<String>> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotal();
        List<List<String>> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "QueryResponse(results=" + this.getResults() + ", total=" + this.getTotal() + ")";
    }

    public QueryResponse() {
    }

    @ConstructorProperties(value={"results", "total"})
    public QueryResponse(List<List<String>> results, int total) {
        this.results = results;
        this.total = total;
    }
}

