/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.dbmon.DBServerType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@IgnoreProtoGen
@UiCodeGen
@TSCodeGen(exclude=true)
public enum QueryStatTypeV2 {
    EXECUTIONS(1, DBServerType.ORACLE),
    CPU_TIME(2, DBServerType.ORACLE),
    ELAPSED_TIME(3, DBServerType.ORACLE),
    ROWS_PROCESSED(4, DBServerType.ORACLE),
    BUFFER_GETS(5, DBServerType.ORACLE),
    DISK_READS(6, DBServerType.ORACLE),
    PARSE_CALLS(7, DBServerType.ORACLE),
    PLAN_HASH_VALUE(8, DBServerType.ORACLE),
    EXECUTION_COUNT(1, DBServerType.MSSQL),
    TOTAL_WORKER_TIME(2, DBServerType.MSSQL),
    TOTAL_ELAPSED_TIME(3, DBServerType.MSSQL),
    TOTAL_PHYSICAL_READS(4, DBServerType.MSSQL),
    TOTAL_LOGICAL_READS(5, DBServerType.MSSQL),
    TOTAL_LOGICAL_WRITES(6, DBServerType.MSSQL),
    TOTAL_CLR_TIME(7, DBServerType.MSSQL),
    PLAN_HANDLE(8, DBServerType.MSSQL),
    NUM_EXECUTIONS(1, DBServerType.DB2),
    TOTAL_EXEC_TIME(2, DBServerType.DB2),
    TOTAL_USR_CPU_TIME(3, DBServerType.DB2),
    NUM_COMPILATIONS(4, DBServerType.DB2),
    ROWS_READ(5, DBServerType.DB2),
    ROWS_WRITTEN(6, DBServerType.DB2),
    STMT_SORTS(7, DBServerType.DB2),
    COUCHBASE_EXECUTIONS(1, DBServerType.COUCHBASE),
    COUCHBASE_ELAPSED_TIME(2, DBServerType.COUCHBASE),
    CALLS(1, DBServerType.POSTGRESQL),
    TOTAL_TIME(2, DBServerType.POSTGRESQL),
    ROWS(3, DBServerType.POSTGRESQL),
    SHARED_BLKS_HIT(4, DBServerType.POSTGRESQL),
    SHARED_BLKS_READ(5, DBServerType.POSTGRESQL),
    SHARED_BLKS_WRITTEN(6, DBServerType.POSTGRESQL),
    CASSANDRA_EXECUTIONS(1, DBServerType.CASSANDRA),
    CASSANDRA_ELAPSED_TIME(2, DBServerType.CASSANDRA),
    HANA_EXECUTION_COUNT(1, DBServerType.HANA),
    HANA_TOTAL_EXECUTION_CPU_TIME(2, DBServerType.HANA),
    HANA_ELAPSED_TIME(3, DBServerType.HANA);

    private static Map<DBServerType, Map<Integer, QueryStatTypeV2>> serverTypeToStatTypes;
    private int id;
    private DBServerType dbType;

    public static QueryStatTypeV2 valueOf(long id, DBServerType serverType) {
        if (serverTypeToStatTypes.get((Object)serverType) == null) {
            return null;
        }
        return serverTypeToStatTypes.get((Object)serverType).get((int)id);
    }

    private QueryStatTypeV2(int id, DBServerType dbType) {
        this.id = id;
        this.dbType = dbType;
    }

    public DBServerType dbType() {
        return this.dbType;
    }

    public int id() {
        return this.id;
    }

    public static Collection<QueryStatTypeV2> queryStatTypesForServerType(DBServerType dbType) {
        return serverTypeToStatTypes.get((Object)dbType).values();
    }

    public static long getTotalElapsedTimeByServerType(DBServerType dbServerType) {
        long statId = -1L;
        switch (dbServerType) {
            case ORACLE: {
                statId = ELAPSED_TIME.id();
                break;
            }
            case MSSQL: 
            case SQLAZURE: {
                statId = TOTAL_ELAPSED_TIME.id();
                break;
            }
            case DB2: {
                statId = TOTAL_EXEC_TIME.id();
                break;
            }
            case COUCHBASE: {
                statId = COUCHBASE_ELAPSED_TIME.id();
                break;
            }
            case POSTGRESQL: {
                statId = TOTAL_TIME.id();
                break;
            }
            case CASSANDRA: {
                statId = CASSANDRA_ELAPSED_TIME.id();
                break;
            }
            case HANA: {
                statId = HANA_ELAPSED_TIME.id();
            }
        }
        return statId;
    }

    static {
        serverTypeToStatTypes = new HashMap<DBServerType, Map<Integer, QueryStatTypeV2>>();
        HashMap typeToStatusTypesMutable = new HashMap();
        for (DBServerType dBServerType : DBServerType.values()) {
            typeToStatusTypesMutable.put(dBServerType, new HashMap());
        }
        for (Enum enum_ : QueryStatTypeV2.values()) {
            DBServerType type = ((QueryStatTypeV2)enum_).dbType();
            ((Map)typeToStatusTypesMutable.get((Object)type)).put(((QueryStatTypeV2)enum_).id, enum_);
        }
        for (Map.Entry entry : typeToStatusTypesMutable.entrySet()) {
            DBServerType type = (DBServerType)((Object)entry.getKey());
            Map map = (Map)entry.getValue();
            Map identifiersUnmodifiable = Collections.unmodifiableMap(map);
            serverTypeToStatTypes.put(type, identifiersUnmodifiable);
        }
    }
}

