/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.dbmon.QueryStatType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@IgnoreProtoGen
@TSCodeGen(exclude=true)
public class QueryStatMeasurement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long timestamp;
    private long queryId;
    private String groupId;
    private long serverId;
    private Map<Integer, Number> values;
    private BigInteger[] planHandles;

    public QueryStatMeasurement() {
    }

    public QueryStatMeasurement(Long queryId, Map<QueryStatType, Long> values) {
        this.queryId = queryId;
        this.addAllValues(values);
    }

    public Map<Integer, Number> getValues() {
        return this.values;
    }

    public void setValues(Map<Integer, Number> values) {
        this.values = values;
    }

    public void setQueryId(long queryId) {
        this.queryId = queryId;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public BigInteger[] getPlanHandles() {
        return this.planHandles;
    }

    public void setPlanHandles(BigInteger[] planHandles) {
        this.planHandles = planHandles;
    }

    public QueryStatMeasurement addValue(QueryStatType type, Long value) {
        if (this.values == null) {
            this.values = new HashMap<Integer, Number>();
        }
        this.values.put(type.id(), value);
        return this;
    }

    public void addAllValues(Map<QueryStatType, Long> valuesToAdd) {
        for (Map.Entry<QueryStatType, Long> entry : valuesToAdd.entrySet()) {
            this.addValue(entry.getKey(), entry.getValue());
        }
    }

    public Long statValueAsLong(QueryStatType stat) {
        Long value = 0L;
        Number number = this.values.get(stat.id());
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public String statValueAsString(QueryStatType stat) {
        String value = null;
        Number obj = this.values.get(stat.id());
        if (stat == QueryStatType.PLAN_HANDLE && obj instanceof BigInteger) {
            value = "0x" + ((BigInteger)obj).toString(16);
        } else if (obj != null) {
            value = String.valueOf(obj);
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("QueryStatMeasurement{");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", queryId=").append(this.queryId);
        sb.append(", groupId=").append(this.groupId);
        sb.append(", serverId=").append(this.serverId);
        sb.append(", values=").append(this.values);
        sb.append(", planHandles=").append(Arrays.toString(this.planHandles));
        sb.append('}');
        return sb.toString();
    }

    public List<String> collectPlanHandles() {
        String planHandle;
        LinkedList<String> ret = new LinkedList<String>();
        if (this.planHandles != null) {
            for (BigInteger planHandle2 : this.planHandles) {
                ret.add("0x" + planHandle2.toString(16));
            }
        }
        if (ret.isEmpty() && (planHandle = this.statValueAsString(QueryStatType.PLAN_HASH_VALUE)) != null && !planHandle.equals("")) {
            ret.add(planHandle);
        }
        if (ret.isEmpty() && (planHandle = this.statValueAsString(QueryStatType.PLAN_HANDLE)) != null && !planHandle.equals("")) {
            ret.add(planHandle);
        }
        return ret;
    }
}

