/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.google.common.collect.ImmutableMap;
import com.singularity.ee.controller.api.dto.dbmon.DBHostOS;
import com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig;
import com.singularity.ee.controller.api.dto.dbmon.DBServer;
import com.singularity.ee.controller.api.dto.dbmon.DBServerType;
import org.apache.commons.lang3.ArrayUtils;

@UiCodeGen
@TSCodeGen(exclude=true)
public enum DBHardwareMonitoringType {
    NONE,
    REMOTE,
    SIM_INTEGRATED,
    QUERY_BASED_MSSQL,
    QUERY_BASED_ORACLE,
    QUERY_BASED_HANA,
    RDS_BASED;

    private static final String[] HARDWARE_METRICS;
    private static final String[] SIM_BASED_HARDWARE_METRICS;
    private static final String[] SQLSERVER_BASIC_HARDWARE_METRICS;
    private static final String[] ORACLE_BASIC_HARDWARE_METRICS;
    private static final String[] HANA_BASIC_HARDWARE_METRICS;
    private static final String[] RDS_HARDWARE_METRICS;
    private static final String[] HARDWARE_METRICS_FOR_LIVE_VIEW;
    private static final String[] RDS_METRICS_FOR_LIVE_VIEW;
    private static final String[] BASIC_HARDWARE_METRICS_FOR_LIVE_VIEW;
    private static final String[] BASIC_HARDWARE_METRICS_ORACLE_FOR_LIVE_VIEW;
    private static final String[] BASIC_HARDWARE_METRICS_HANA_FOR_LIVE_VIEW;
    public static final ImmutableMap<DBHardwareMonitoringType, String[]> DASHBOARD_HARDWARE_METRICS;
    public static final ImmutableMap<DBHardwareMonitoringType, String[]> LIVE_VIEW_HARDWARE_METRICS;

    public static DBHardwareMonitoringType getHardwareMonitoringType(DBMonitorConfig config, boolean simIntegrationEnabled, DBServer ... servers) {
        if (servers != null) {
            for (DBServer server : servers) {
                if (server.getConfigId() == config.getId()) continue;
                return NONE;
            }
        }
        if (simIntegrationEnabled && servers != null) {
            for (DBServer server : servers) {
                if (!DBHardwareMonitoringType.isSimMachineMapped(server)) continue;
                return SIM_INTEGRATED;
            }
        }
        if (config.isEnableOSMonitor()) {
            if (config.getHostOS() == DBHostOS.RDS) {
                return RDS_BASED;
            }
            return REMOTE;
        }
        if (config.getType() == DBServerType.MSSQL) {
            return QUERY_BASED_MSSQL;
        }
        if (config.getType() == DBServerType.ORACLE) {
            return QUERY_BASED_ORACLE;
        }
        if (config.getType() == DBServerType.HANA) {
            return QUERY_BASED_HANA;
        }
        return NONE;
    }

    private static boolean isSimMachineMapped(DBServer server) {
        return server != null && server.getSimMachineId() > 0L;
    }

    public boolean isHardwareMetricsAvailable() {
        return this != NONE;
    }

    public String[] getHardwareMetricsForDashboard() {
        return (String[])DASHBOARD_HARDWARE_METRICS.get((Object)this);
    }

    public String[] getHardwareMetricsForLiveView() {
        return (String[])LIVE_VIEW_HARDWARE_METRICS.get((Object)this);
    }

    static {
        HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|Memory|Used %", "Hardware Resources|Disks|KB read/sec", "Hardware Resources|Disks|KB written/sec", "Hardware Resources|Network|Incoming KB/sec", "Hardware Resources|Network|Outgoing KB/sec"};
        SIM_BASED_HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|%Busy", "Hardware Resources|Memory|Used %", "Hardware Resources|Disks|Reads/sec", "Hardware Resources|Disks|Writes/sec", "Hardware Resources|Network|Incoming KB/sec", "Hardware Resources|Network|Outgoing KB/sec"};
        SQLSERVER_BASIC_HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|%Busy", "Hardware Resources|Memory|Used %", "Hardware Resources|Disks|KB read/sec", "Hardware Resources|Disks|KB written/sec"};
        ORACLE_BASIC_HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|Memory|Used %", "Hardware Resources|Memory|Total (MB)", "DB|Performance|Physical Read Total Bytes Per Sec", "DB|Performance|Physical Write Total Bytes Per Sec", "DB|Server Statistic|bytes received via SQL*Net from client", "DB|Server Statistic|bytes sent via SQL*Net to client"};
        HANA_BASIC_HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|Memory|Used %", "Hardware Resources|Memory|Total (MB)", "Hardware Resources|Network|Incoming KB", "Hardware Resources|Network|Outgoing KB", "Hardware Resources|Disks|KB read/sec", "Hardware Resources|Disks|KB written/sec"};
        RDS_HARDWARE_METRICS = new String[]{"Hardware Resources|CPU|%Busy", "Hardware Resources|Memory|Free (MB)", "Hardware Resources|Disks|KB read/sec", "Hardware Resources|Disks|KB written/sec", "Hardware Resources|Network|Incoming KB/sec", "Hardware Resources|Network|Outgoing KB/sec"};
        HARDWARE_METRICS_FOR_LIVE_VIEW = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|CPU|%Idle", "Hardware Resources|CPU|IOWait", "Hardware Resources|Memory|Used (MB)", "Hardware Resources|Memory|Total (MB)", "Hardware Resources|Memory|Used %"};
        RDS_METRICS_FOR_LIVE_VIEW = new String[]{"Hardware Resources|CPU|%Busy", "Hardware Resources|Memory|Free (MB)"};
        BASIC_HARDWARE_METRICS_FOR_LIVE_VIEW = new String[]{"Hardware Resources|CPU|%Busy", "Hardware Resources|Memory|Used %", "Hardware Resources|Memory|Total (MB)"};
        BASIC_HARDWARE_METRICS_ORACLE_FOR_LIVE_VIEW = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|CPU|IOWait", "Hardware Resources|Memory|Used %", "Hardware Resources|Memory|Total (MB)"};
        BASIC_HARDWARE_METRICS_HANA_FOR_LIVE_VIEW = new String[]{"Hardware Resources|CPU|System", "Hardware Resources|CPU|User", "Hardware Resources|CPU|IOWait", "Hardware Resources|Memory|Used %", "Hardware Resources|Memory|Total (MB)"};
        DASHBOARD_HARDWARE_METRICS = ImmutableMap.builder().put((Object)NONE, (Object)ArrayUtils.EMPTY_STRING_ARRAY).put((Object)REMOTE, (Object)HARDWARE_METRICS).put((Object)SIM_INTEGRATED, (Object)SIM_BASED_HARDWARE_METRICS).put((Object)QUERY_BASED_MSSQL, (Object)SQLSERVER_BASIC_HARDWARE_METRICS).put((Object)QUERY_BASED_ORACLE, (Object)ORACLE_BASIC_HARDWARE_METRICS).put((Object)QUERY_BASED_HANA, (Object)HANA_BASIC_HARDWARE_METRICS).put((Object)RDS_BASED, (Object)RDS_HARDWARE_METRICS).build();
        LIVE_VIEW_HARDWARE_METRICS = ImmutableMap.builder().put((Object)NONE, (Object)ArrayUtils.EMPTY_STRING_ARRAY).put((Object)REMOTE, (Object)HARDWARE_METRICS_FOR_LIVE_VIEW).put((Object)SIM_INTEGRATED, (Object)BASIC_HARDWARE_METRICS_FOR_LIVE_VIEW).put((Object)QUERY_BASED_MSSQL, (Object)BASIC_HARDWARE_METRICS_FOR_LIVE_VIEW).put((Object)QUERY_BASED_ORACLE, (Object)BASIC_HARDWARE_METRICS_ORACLE_FOR_LIVE_VIEW).put((Object)QUERY_BASED_HANA, (Object)BASIC_HARDWARE_METRICS_HANA_FOR_LIVE_VIEW).put((Object)RDS_BASED, (Object)RDS_METRICS_FOR_LIVE_VIEW).build();
    }
}

