/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.AAppDynamicsAgent;
import com.singularity.ee.controller.api.dto.AConfigObject;
import com.singularity.ee.controller.api.dto.dbmon.DBAgentInfo;
import com.singularity.ee.controller.api.dto.dbmon.DBAgentListItem;
import com.singularity.ee.controller.api.dto.dbmon.dbagentoperations.DBAgentOperationParameters;

@UiCodeGen
@TSCodeGen(exclude=true)
public class DBAgent
extends AConfigObject {
    private static final long serialVersionUID = 1L;
    private String hostName;
    private AAppDynamicsAgent agentDetails;
    private String agentName;
    private boolean agentUp;
    private boolean authoritative;
    private DBAgentOperationParameters operationParams;
    private long nodeId;

    public DBAgent() {
    }

    public DBAgent(DBAgent other) {
        this.setId(other.getId());
        this.hostName = other.getHostName();
        this.agentDetails = other.getAgentDetails();
        this.agentName = other.getAgentName();
        this.agentUp = other.isAgentUp();
        this.authoritative = other.isAuthoritative();
        this.operationParams = other.operationParams;
        this.nodeId = other.nodeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public AAppDynamicsAgent getAgentDetails() {
        return this.agentDetails;
    }

    public void setAgentDetails(AAppDynamicsAgent agentDetails) {
        this.agentDetails = agentDetails;
        this.setId(agentDetails.getId());
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public boolean isAgentUp() {
        return this.agentUp;
    }

    public void setAgentUp(boolean agentUp) {
        this.agentUp = agentUp;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public void setAuthoritative(boolean authoritative) {
        this.authoritative = authoritative;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public DBAgentListItem toListItem() {
        DBAgentListItem.DBAgentListItemBuilder listItemBuilder = DBAgentListItem.builder().id(this.agentDetails.getId()).hostName(this.hostName).version(this.agentDetails.getAgentVersion()).agentName(this.agentName);
        DBAgentStatus agentStatus = this.agentUp ? (this.authoritative ? DBAgentStatus.ACTIVE : DBAgentStatus.PASSIVE) : DBAgentStatus.DOWN;
        listItemBuilder.status(agentStatus.name());
        listItemBuilder.startTime(this.agentDetails.getLastStartTime());
        listItemBuilder.installDir(this.agentDetails.getInstallDir());
        return listItemBuilder.build();
    }

    public DBAgentInfo toCompleteInfo() {
        DBAgentInfo listItem = new DBAgentInfo();
        listItem.setDbAgentListItem(this.toListItem());
        listItem.setDbAgentOperationParameters(this.operationParams);
        return listItem;
    }

    public void setOperationParams(DBAgentOperationParameters operationParams) {
        this.operationParams = operationParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBAgent)) {
            return false;
        }
        DBAgent dbAgent = (DBAgent)o;
        return this.getId() == dbAgent.getId();
    }

    @Override
    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @UiCodeGen
    @TSCodeGen(exclude=true)
    public static enum DBAgentStatus {
        ACTIVE,
        PASSIVE,
        DOWN;

    }
}

