/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.ConditionOperator;
import com.singularity.ee.controller.api.constants.ConditionOperatorHelper;
import com.singularity.ee.controller.api.constants.ConditionUnitType;
import com.singularity.ee.controller.api.constants.ConditionUnitTypeHelper;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.ConditionValueFunction;
import com.singularity.ee.controller.api.dto.IEntityDefinition;
import com.singularity.ee.util.math.DoubleUtils;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TriggeredCondition
extends APersistentObject {
    private static final long serialVersionUID = 1L;
    public static final TriggeredCondition[] EMPTY_TRIGGERED_CONDITION = new TriggeredCondition[0];
    private String conditionName;
    private long conditionId;
    private ConditionOperator operator;
    private ConditionValueFunction valueFunction;
    private double thresholdValue;
    private double observedValue;
    private double baselineValue;
    private double stddevValue;
    private String baselineDisplayName;
    private long baselineId;
    private boolean useDefaultBaseline;
    private ConditionUnitType valueUnitType;
    private IEntityDefinition aggregationScope;
    private String triggeredMetricDisplayName;
    private long triggeredMetricId;
    private boolean triggersEnabled;
    private int triggers;
    private int minimumTriggers;
    private String conditionShortName;

    public String getBaselineDisplayName() {
        return this.baselineDisplayName;
    }

    public void setBaselineDisplayName(String baselineDisplayName) {
        this.baselineDisplayName = baselineDisplayName;
    }

    public long getBaselineId() {
        return this.baselineId;
    }

    public void setBaselineId(long baselineId) {
        this.baselineId = baselineId;
    }

    public boolean isUseDefaultBaseline() {
        return this.useDefaultBaseline;
    }

    public void setUseDefaultBaseline(boolean useDefaultBaseline) {
        this.useDefaultBaseline = useDefaultBaseline;
    }

    public ConditionUnitType getValueUnitType() {
        return this.valueUnitType;
    }

    public void setValueUnitType(ConditionUnitType valueUnitType) {
        this.valueUnitType = valueUnitType;
    }

    public String getValueUnitTypeDisplayName() {
        return ConditionUnitTypeHelper.getDisplayName(this.valueUnitType);
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ConditionOperator operator) {
        this.operator = operator;
    }

    public String getOperatorDisplayName() {
        switch (this.valueUnitType) {
            case ABSOLUTE: {
                return ConditionOperatorHelper.getDisplayName(this.operator);
            }
            case BASELINE_STANDARD_DEVIATION: 
            case BASELINE_PERCENTAGE: 
            case BASELINE_PERCENTILE: {
                return ConditionOperatorHelper.getDisplayNameForBaseline(this.operator);
            }
        }
        return null;
    }

    public ConditionValueFunction getValueFunction() {
        return this.valueFunction;
    }

    public void setValueFunction(ConditionValueFunction valueFunction) {
        this.valueFunction = valueFunction;
    }

    public double getThresholdValue() {
        return this.thresholdValue;
    }

    public void setThresholdValue(double thresholdValue) {
        this.thresholdValue = thresholdValue;
    }

    public double getObservedValue() {
        return this.observedValue;
    }

    public void setObservedValue(double observedValue) {
        this.observedValue = DoubleUtils.roundToOneDigitAfterDecimalPoint(observedValue);
    }

    public double getBaselineValue() {
        return this.baselineValue;
    }

    public void setBaselineValue(double baselineValue) {
        this.baselineValue = baselineValue;
    }

    public double getStddevValue() {
        return this.stddevValue;
    }

    public void setStddevValue(double stddevValue) {
        this.stddevValue = stddevValue;
    }

    public void setAggregationScope(IEntityDefinition aggregationScope) {
        this.aggregationScope = aggregationScope;
    }

    public IEntityDefinition getAggregationScope() {
        return this.aggregationScope;
    }

    public long getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(long conditionId) {
        this.conditionId = conditionId;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }

    public String getTriggeredMetricDisplayName() {
        return this.triggeredMetricDisplayName;
    }

    public void setTriggeredMetricDisplayName(String metricDisplayName) {
        this.triggeredMetricDisplayName = metricDisplayName;
    }

    public long getTriggeredMetricId() {
        return this.triggeredMetricId;
    }

    public void setTriggeredMetricId(long triggeredMetricId) {
        this.triggeredMetricId = triggeredMetricId;
    }

    public boolean isTriggersEnabled() {
        return this.triggersEnabled;
    }

    public void setTriggersEnabled(boolean triggersEnabled) {
        this.triggersEnabled = triggersEnabled;
    }

    public int getTriggers() {
        return this.triggers;
    }

    public void setTriggers(int triggers) {
        this.triggers = triggers;
    }

    public int getMinimumTriggers() {
        return this.minimumTriggers;
    }

    public void setMinimumTriggers(int minimumTriggers) {
        this.minimumTriggers = minimumTriggers;
    }

    public String getConditionShortName() {
        return this.conditionShortName;
    }

    public void setConditionShortName(String conditionShortName) {
        this.conditionShortName = conditionShortName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TriggeredCondition)) {
            return false;
        }
        TriggeredCondition that = (TriggeredCondition)obj;
        return (this.getConditionShortName() == null ? that.getConditionShortName() == null : this.getConditionShortName().equals(that.getConditionShortName())) && (this.getTriggeredMetricDisplayName() == null ? that.getTriggeredMetricDisplayName() == null : this.getTriggeredMetricDisplayName().equals(that.getTriggeredMetricDisplayName())) && this.getObservedValue() == that.getObservedValue() && this.getBaselineValue() == that.getBaselineValue() && this.isUseDefaultBaseline() == that.isUseDefaultBaseline() && this.isTriggersEnabled() == that.isTriggersEnabled() && this.getMinimumTriggers() == that.getMinimumTriggers() && this.getValueUnitType() == that.getValueUnitType() && (this.getBaselineDisplayName() == null ? that.getBaselineDisplayName() == null : this.getBaselineDisplayName().equals(that.getBaselineDisplayName())) && this.getTriggeredMetricId() == that.getTriggeredMetricId() && this.getBaselineId() == that.getBaselineId() && this.getStddevValue() == that.getStddevValue() && this.getThresholdValue() == that.getThresholdValue();
    }

    @Override
    public int hashCode() {
        int result = this.conditionShortName != null ? this.conditionShortName.hashCode() : 0;
        result = 31 * result + (this.triggeredMetricDisplayName != null ? this.triggeredMetricDisplayName.hashCode() : 0);
        result = (int)((double)(31 * result) + this.observedValue);
        result = (int)((double)(31 * result) + this.baselineValue);
        result = 31 * result + (this.useDefaultBaseline ? 1 : 0);
        result = 31 * result + (this.triggersEnabled ? 1 : 0);
        result = 31 * result + this.minimumTriggers;
        result = 31 * result + this.valueUnitType.hashCode();
        result = 31 * result + (this.baselineDisplayName != null ? this.baselineDisplayName.hashCode() : 0);
        result = (int)((long)(31 * result) + this.baselineId);
        result = (int)((double)(31 * result) + this.stddevValue);
        result = (int)((double)(31 * result) + this.thresholdValue);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TriggeredCondition{");
        sb.append("conditionName='").append(this.conditionName).append('\'');
        sb.append(", conditionId=").append(this.conditionId);
        sb.append(", operator=").append((Object)this.operator);
        sb.append(", valueFunction=").append(this.valueFunction);
        sb.append(", thresholdValue=").append(this.thresholdValue);
        sb.append(", observedValue=").append(this.observedValue);
        sb.append(", baselineValue=").append(this.baselineValue);
        sb.append(", stddevValue=").append(this.stddevValue);
        sb.append(", baselineDisplayName='").append(this.baselineDisplayName).append('\'');
        sb.append(", baselineId=").append(this.baselineId);
        sb.append(", useDefaultBaseline=").append(this.useDefaultBaseline);
        sb.append(", valueUnitType=").append((Object)this.valueUnitType);
        sb.append(", aggregationScope=").append(this.aggregationScope);
        sb.append('}');
        return sb.toString();
    }
}

