/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.TimeRange;
import com.singularity.ee.util.clock.ClockUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

@UiCodeGen
@TSCodeGen(exclude=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeRangeSpecifier {
    private static int MILLISECONDS_PER_MINUTE = 60000;
    protected TimeRangeSpecifierType type;
    protected int durationInMinutes;
    protected Date startTime;
    protected Date endTime;
    protected TimeRange timeRange;
    private boolean timeRangeAdjusted;
    private String timeZone;

    public TimeRangeSpecifier() {
    }

    public TimeRangeSpecifier(Date startTime, Date endTime) {
        this.type = TimeRangeSpecifierType.BETWEEN_TIMES;
        this.startTime = new Date(startTime.getTime());
        this.endTime = new Date(endTime.getTime());
        this.durationInMinutes = (int)((this.endTime.getTime() - this.startTime.getTime()) / (long)MILLISECONDS_PER_MINUTE);
    }

    public TimeRangeSpecifier(long startTime, long endTime) {
        this(new Date(startTime), new Date(endTime));
    }

    public TimeRangeSpecifier(TimeRangeSpecifierType type, int durationInMinutes, Date startTime, Date endTime) {
        this.type = type;
        this.setDurationInMinutes(durationInMinutes);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setTimeZone(ClockUtils.getDefaultServerTimeZone());
        this.prepareForStorage();
    }

    public TimeRangeSpecifier(TimeRangeSpecifierType type, int durationInMinutes, Date startTime, Date endTime, String timeZone) {
        this.type = type;
        this.setDurationInMinutes(durationInMinutes);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setTimeZone(timeZone);
        this.prepareForStorage();
    }

    public TimeRangeSpecifier copy() {
        TimeRangeSpecifier copy = new TimeRangeSpecifier();
        copy.type = this.type;
        copy.durationInMinutes = this.durationInMinutes;
        Date start = null;
        Date end = null;
        if (null != this.startTime) {
            start = new Date(this.startTime.getTime());
        }
        if (null != this.endTime) {
            end = new Date(this.endTime.getTime());
        }
        copy.startTime = start;
        copy.endTime = end;
        if (this.timeRange != null) {
            TimeRange timeRangeCopy = new TimeRange();
            timeRangeCopy.setStartTime(this.timeRange.getStartTime());
            timeRangeCopy.setEndTime(this.timeRange.getEndTime());
            copy.timeRange = timeRangeCopy;
        }
        copy.timeZone = this.timeZone;
        return copy;
    }

    public void prepareForStorage() {
        TimeRangeSpecifierType type = this.getType();
        if (type == null) {
            throw new IllegalStateException("time range specifier type must be specified");
        }
        switch (type) {
            case BEFORE_NOW: {
                this.startTime = null;
                this.endTime = null;
                if (this.getDurationInMinutes() != 0) break;
                throw new IllegalStateException("duration in minutes must be specified");
            }
            case BEFORE_TIME: {
                this.startTime = null;
                if (this.endTime == null) {
                    throw new IllegalStateException("end time is not specified");
                }
                if (this.getDurationInMinutes() != 0) break;
                throw new IllegalStateException("duration in minutes must be specified");
            }
            case AFTER_TIME: {
                this.endTime = null;
                if (this.startTime == null) {
                    throw new IllegalStateException("start time is not specified");
                }
                if (this.getDurationInMinutes() != 0) break;
                throw new IllegalStateException("duration in minutes must be specified");
            }
            case BETWEEN_TIMES: {
                if (this.startTime == null) {
                    throw new IllegalStateException("start time is not specified");
                }
                if (this.endTime == null) {
                    throw new IllegalStateException("end time is not specified");
                }
                if (this.startTime.after(this.endTime)) {
                    throw new IllegalStateException("start time later than end time");
                }
                this.durationInMinutes = 0;
                break;
            }
            case PREV_DAY_END: 
            case PREV_WEEK_END: 
            case PREV_MONTH_END: 
            case ALL: 
            case NON_RESTRICTIVE_ALL: {
                this.startTime = null;
                this.endTime = null;
                this.durationInMinutes = 0;
                break;
            }
            default: {
                throw new IllegalStateException("time range specifier type " + (Object)((Object)type) + " is not supported");
            }
        }
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public TimeRange getTimeRange() {
        if (this.timeRange != null && this.type != TimeRangeSpecifierType.ALL) {
            return this.timeRange;
        }
        this.timeRange = this.readTimeRangeWithoutMutate();
        switch (this.type) {
            case PREV_DAY_END: 
            case PREV_WEEK_END: {
                if (this.durationInMinutes > 0) break;
                this.durationInMinutes = (int)(this.timeRange.calculateDuration() / 60000L);
                break;
            }
            case BETWEEN_TIMES: 
            case PREV_MONTH_END: 
            case ALL: 
            case NON_RESTRICTIVE_ALL: {
                this.durationInMinutes = (int)(this.timeRange.calculateDuration() / 60000L);
                break;
            }
        }
        return this.timeRange;
    }

    public TimeRange readTimeRangeWithoutMutate() {
        return this.readTimeRangeWithoutMutate(ClockUtils.getCurrentTime());
    }

    public TimeRange readTimeRangeWithoutMutate(long currentTimeMillis) {
        if (this.timeRange != null && this.type != TimeRangeSpecifierType.ALL) {
            return this.timeRange;
        }
        if (this.type == null) {
            throw new IllegalStateException("the time range specifier type must be specified");
        }
        Date startTime = null;
        Date endTime = null;
        GregorianCalendar cal = null;
        Date now = new Date(currentTimeMillis);
        switch (this.type) {
            case BEFORE_NOW: {
                endTime = now;
                cal = new GregorianCalendar();
                cal.setTime(endTime);
                ((Calendar)cal).add(12, -1 * this.getDurationInMinutes());
                startTime = cal.getTime();
                break;
            }
            case BEFORE_TIME: {
                endTime = this.getEndTime();
                if (endTime.after(now)) {
                    endTime = now;
                }
                cal = new GregorianCalendar();
                cal.setTime(endTime);
                ((Calendar)cal).add(12, -1 * this.getDurationInMinutes());
                startTime = cal.getTime();
                break;
            }
            case AFTER_TIME: {
                startTime = this.getStartTime();
                if (startTime.after(now)) {
                    throw new IllegalArgumentException("Cannot specify future time");
                }
                cal = new GregorianCalendar();
                cal.setTime(startTime);
                ((Calendar)cal).add(12, this.getDurationInMinutes());
                endTime = cal.getTime();
                if (!endTime.after(now)) break;
                endTime = now;
                break;
            }
            case BETWEEN_TIMES: {
                startTime = this.getStartTime();
                endTime = this.getEndTime();
                if (startTime.after(endTime)) {
                    throw new IllegalArgumentException("Cannot specify start time after the end time");
                }
                if (endTime.after(now)) {
                    endTime = now;
                }
                if (!startTime.after(now)) break;
                startTime = now;
                break;
            }
            case ALL: {
                startTime = new Date(0L);
                endTime = now;
                break;
            }
            case NON_RESTRICTIVE_ALL: {
                startTime = new Date(0L);
                endTime = new Date(Long.MAX_VALUE);
                break;
            }
            case PREV_DAY_END: 
            case PREV_WEEK_END: 
            case PREV_MONTH_END: {
                if (this.getDurationInMinutes() > 0) {
                    startTime = ClockUtils.getPreviousTimeSpan(now, this.type, true, this.timeZone);
                    endTime = ClockUtils.getPreviousTimeSpan(now, this.type, false, this.timeZone);
                    break;
                }
                startTime = ClockUtils.getPreviousTimeSpan(now, this.type, false, this.timeZone);
                endTime = now;
                break;
            }
            default: {
                throw new IllegalStateException("time range specifier type " + (Object)((Object)this.type) + " is not supported");
            }
        }
        TimeRange range = new TimeRange();
        range.setEndTime(endTime);
        range.setStartTime(startTime);
        return range;
    }

    public void truncate(int maximumDuration) {
        this.setDurationInMinutes(maximumDuration);
        switch (this.type) {
            case BEFORE_NOW: 
            case BEFORE_TIME: 
            case AFTER_TIME: 
            case PREV_DAY_END: 
            case PREV_WEEK_END: 
            case PREV_MONTH_END: {
                break;
            }
            case BETWEEN_TIMES: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(this.endTime);
                ((Calendar)cal).add(12, -1 * this.getDurationInMinutes());
                this.endTime = cal.getTime();
                break;
            }
            default: {
                throw new IllegalStateException("time range specifier type " + (Object)((Object)this.type) + " is not supported");
            }
        }
    }

    public TimeRangeSpecifierType getType() {
        return this.type;
    }

    public void setType(TimeRangeSpecifierType type) {
        this.type = type;
        this.timeRange = null;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public void setDurationInMinutes(int durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
        this.timeRange = null;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        this.timeRange = null;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.timeRange = null;
    }

    public void setTimeZone(String tz) {
        this.timeZone = tz;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isTimeRangeAdjusted() {
        return this.timeRangeAdjusted;
    }

    public void setTimeRangeAdjusted(boolean timeRangeAdjusted) {
        this.timeRangeAdjusted = timeRangeAdjusted;
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "TimeRangeSpecifier ( type = " + (Object)((Object)this.type) + "    " + "durationInMinutes = " + this.durationInMinutes + "    " + "startTime = " + this.startTime + "    " + "endTime = " + this.endTime + "    " + " )";
        return retValue;
    }

    public String convertToPreferenceString(String delimiter) {
        String endTime = this.endTime != null ? "" + this.endTime.getTime() : "-1";
        String startTime = this.startTime != null ? "" + this.startTime.getTime() : "-1";
        String prefString = "Custom_Time_Range" + delimiter + this.type.toString() + delimiter + endTime + delimiter + startTime + delimiter + this.durationInMinutes;
        return prefString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRangeSpecifier that = (TimeRangeSpecifier)o;
        if (this.durationInMinutes != that.durationInMinutes) {
            return false;
        }
        if (this.timeRangeAdjusted != that.timeRangeAdjusted) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) {
            return false;
        }
        if (this.timeRange != null ? !this.timeRange.equals(that.timeRange) : that.timeRange != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.durationInMinutes;
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.timeRange != null ? this.timeRange.hashCode() : 0);
        result = 31 * result + (this.timeRangeAdjusted ? 1 : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        return result;
    }
}

