/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.PropertyType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.File;
import com.singularity.ee.controller.api.dto.Property;
import com.singularity.ee.util.collections.ArrayUtilsHelper;

@UiCodeGen
@TSCodeGen(exclude=true)
public class PropertyDefinition
extends APersistentObject {
    private PropertyType type;
    private String name;
    private String description;
    private boolean required;
    private String[] allowedStringValues;
    private int stringMaxLen;
    private String upperNumericBound;
    private String lowerNumericBound;
    private String defaultStringValue;
    private File defaultFileBinary;

    public String getUpperNumericBound() {
        return this.upperNumericBound;
    }

    public void setUpperNumericBound(String upperNumericBound) {
        this.upperNumericBound = upperNumericBound;
    }

    public String getLowerNumericBound() {
        return this.lowerNumericBound;
    }

    public void setLowerNumericBound(String lowerNumericBound) {
        this.lowerNumericBound = lowerNumericBound;
    }

    @Override
    public PropertyDefinition copy() {
        File file;
        PropertyDefinition copy = new PropertyDefinition();
        copy.setId(this.getId());
        copy.setVersion(this.getVersion());
        copy.setName(this.getName());
        copy.setType(this.getType());
        copy.setDescription(this.getDescription());
        copy.setRequired(this.isRequired());
        copy.setStringMaxLen(this.getStringMaxLen());
        copy.setDefaultStringValue(this.getDefaultStringValue());
        copy.setUpperNumericBound(this.getUpperNumericBound());
        copy.setLowerNumericBound(this.getLowerNumericBound());
        String[] allowedStringValues = this.getAllowedStringValues();
        if (allowedStringValues != null) {
            String[] allowedStringValuesCopy = new String[allowedStringValues.length];
            for (int i = 0; i < allowedStringValuesCopy.length; ++i) {
                allowedStringValuesCopy[i] = allowedStringValues[i];
            }
            copy.setAllowedStringValues(allowedStringValuesCopy);
        }
        if ((file = this.getDefaultFileBinary()) != null) {
            copy.setDefaultFileBinary(file.copy());
        }
        return copy;
    }

    public void merge(PropertyDefinition newState) {
        if (this.getType() != newState.getType()) {
            throw new IllegalArgumentException("property type cannot be changed on merge: existing type=" + (Object)((Object)this.getType()) + "; new type=" + (Object)((Object)newState.getType()));
        }
        this.setName(newState.getName());
        this.setDescription(newState.getDescription());
        this.setRequired(newState.isRequired());
        PropertyType type = this.getType();
        switch (type) {
            case STRING: {
                this.setStringMaxLen(newState.getStringMaxLen());
                this.setAllowedStringValues(newState.getAllowedStringValues());
                this.setDefaultStringValue(newState.getDefaultStringValue());
                break;
            }
            case FILE: {
                File newFile = newState.getDefaultFileBinary();
                if (newFile == null) break;
                File file = this.getDefaultFileBinary();
                if (file == null) {
                    file = new File();
                    this.setDefaultFileBinary(file);
                }
                file.setUploadPending(true);
                file.setFileName(newFile.getFileName());
                break;
            }
            case INTEGER: 
            case FLOATING_POINT: {
                this.setUpperNumericBound(newState.getUpperNumericBound());
                this.setLowerNumericBound(newState.getLowerNumericBound());
                break;
            }
            case BOOLEAN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not allowed for type " + (Object)((Object)this.getType()));
            }
        }
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    public void setDefaultStringValue(String defaultStringValue) {
        this.defaultStringValue = defaultStringValue;
    }

    public File getDefaultFileBinary() {
        return this.defaultFileBinary;
    }

    public void setDefaultFileBinary(File defaultFileBinary) {
        this.defaultFileBinary = defaultFileBinary;
    }

    public int getStringMaxLen() {
        return this.stringMaxLen;
    }

    public void setStringMaxLen(int stringMaxLen) {
        this.stringMaxLen = stringMaxLen;
    }

    public String[] getAllowedStringValues() {
        return this.allowedStringValues;
    }

    public void setAllowedStringValues(String ... allowedStringValues) {
        this.allowedStringValues = allowedStringValues;
    }

    public static PropertyDefinition getDefinition(PropertyDefinition[] definitions, String name) {
        for (PropertyDefinition definition : definitions) {
            if (!definition.getName().equals(name)) continue;
            return definition;
        }
        return null;
    }

    public static Object getDefaultValue(PropertyDefinition[] definitions, String name) {
        return PropertyDefinition.getDefaultValue(PropertyDefinition.getDefinition(definitions, name));
    }

    public static Object getDefaultValue(PropertyDefinition definition) {
        if (definition != null) {
            if (definition.getType() == PropertyType.STRING) {
                return definition.getDefaultStringValue();
            }
            return definition.getDefaultFileBinary();
        }
        return null;
    }

    @Override
    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "PropertyDefinition ( " + super.toString() + "    " + "id = " + this.getId() + "    " + "type = " + (Object)((Object)this.type) + "    " + "name = " + this.name + "    " + "description = " + this.description + "    " + "required = " + this.required + "    " + "allowedStringValues = " + ArrayUtilsHelper.arrayOfCustomObjectsToString(this.allowedStringValues) + "    " + "defaultStringValue = " + this.defaultStringValue + "    " + "stringMaxLen = " + this.stringMaxLen + "    " + "upperNumericBound = " + this.upperNumericBound + "    " + "lowerNumericBound = " + this.lowerNumericBound + "    " + "defaultFileBinary = " + this.defaultFileBinary + "    " + " )";
        return retValue;
    }

    public Property createValidProperty() {
        Property property = new Property();
        property.setDefinition(this);
        switch (this.type) {
            case STRING: {
                String[] allowedStringValues = this.getAllowedStringValues();
                if (allowedStringValues != null && allowedStringValues.length > 0) {
                    property.setStringValue(allowedStringValues[0]);
                    break;
                }
                if (this.required) {
                    property.setStringValue("string-value");
                    break;
                }
                property.setStringValue(" ");
                break;
            }
            case FILE: {
                File file = new File();
                file.setFileName("file.txt");
                property.setFileBinary(file);
                break;
            }
            case BOOLEAN: {
                property.setStringValue(Boolean.TRUE.toString());
                break;
            }
            case INTEGER: 
            case FLOATING_POINT: {
                property.setStringValue(String.valueOf(0));
            }
        }
        return property;
    }

    public PropertyDefinition deepCopy() {
        PropertyDefinition deepCopy = this.copy();
        deepCopy.setId(0L);
        deepCopy.setVersion(0);
        return deepCopy;
    }
}

