/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.PropertyType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.File;
import com.singularity.ee.controller.api.dto.PropertyDefinition;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;

@UiCodeGen
@TSCodeGen(exclude=true)
public class Property
extends APersistentObject {
    private PropertyDefinition definition;
    private String stringValue;
    private File fileBinary;

    public Property() {
    }

    public Property(PropertyDefinition definition, String stringValue) {
        this.definition = definition;
        this.stringValue = stringValue;
    }

    @Override
    public Property copy() {
        PropertyDefinition def;
        Property copy = new Property();
        copy.setId(this.getId());
        copy.setVersion(this.getVersion());
        copy.setStringValue(this.getStringValue());
        File file = this.getFileBinary();
        if (file != null) {
            copy.setFileBinary(file.copy());
        }
        if ((def = this.getDefinition()) != null) {
            copy.setDefinition(def.copy());
        }
        return copy;
    }

    public Property deepCopy() {
        PropertyDefinition def;
        Property deepCopy = new Property();
        deepCopy.setId(0L);
        deepCopy.setVersion(0);
        deepCopy.setStringValue(this.getStringValue());
        File file = this.getFileBinary();
        if (file != null) {
            deepCopy.setFileBinary(file.deepCopy());
        }
        if ((def = this.getDefinition()) != null) {
            deepCopy.setDefinition(def.deepCopy());
        }
        return deepCopy;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    public File getFileBinary() {
        return this.fileBinary;
    }

    public void setFileBinary(File fileBinary) {
        this.fileBinary = fileBinary;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Property) {
            Property propObj = (Property)obj;
            return this.getDefinition().getName().equals(propObj.getDefinition().getName()) && Property.getPropertyValue(this).equals(Property.getPropertyValue(propObj));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.definition != null ? this.definition.hashCode() : 0;
        result = 31 * result + Property.getPropertyValue(this).hashCode();
        return result;
    }

    public static Object getRequiredPropertyValue(Property[] properties, String name) {
        return Property.getPropertyValue(Property.getProperty(properties, name));
    }

    public static Object getPropertyValue(Property property) {
        if (property != null) {
            if (property.getDefinition().getType() == PropertyType.FILE) {
                return property.getFileBinary();
            }
            return property.getStringValue();
        }
        return null;
    }

    public static Property getProperty(Property[] properties, String name) {
        for (Property property : properties) {
            PropertyDefinition definition = property.getDefinition();
            if (!definition.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public static Object getDefaultPropertyValue(Property[] properties, PropertyDefinition[] definitions, String name) {
        Property property = Property.getProperty(properties, name);
        if (property != null) {
            return Property.getPropertyValue(property);
        }
        return PropertyDefinition.getDefaultValue(definitions, name);
    }

    @Override
    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "Property ( " + super.toString() + "    " + "id = " + this.getId() + "    " + "definition = " + this.definition + "    " + "stringValue = " + this.stringValue + "    " + "fileBinary = " + this.fileBinary + "    " + " )";
        return retValue;
    }

    public static Property[] createPropertiesForDefinitions(PropertyDefinition ... definitions) {
        ArrayList<Property> properties = new ArrayList<Property>(definitions.length);
        for (PropertyDefinition definition : definitions) {
            properties.add(definition.createValidProperty());
        }
        return CollectionHelper.collectionToArray(properties, new Property[0]);
    }

    public static PropertyDefinition[] getPropertyDefinitionsOfProperties(Property[] properties) {
        if (properties == null) {
            return new PropertyDefinition[0];
        }
        PropertyDefinition[] definitions = new PropertyDefinition[properties.length];
        int i = 0;
        for (Property property : properties) {
            definitions[i++] = property.getDefinition();
        }
        return definitions;
    }
}

