/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.EqualsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@GenProto(protoFile="DtoBase.proto", needsList=true, replacementMessage=".appdynamics.pb.Common.NameValuePair", replacementDefiningProto="Common.proto")
@UiCodeGen
public class NameValuePair
extends APersistentObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final NameValuePair[] EMPTY_NAME_VALUE_PAIR_ARRAY = new NameValuePair[0];
    @FieldPosition(value=2)
    private String name;
    @FieldPosition(value=3)
    private String value;

    public NameValuePair() {
    }

    public NameValuePair(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public NameValuePair(String name, Object value) {
        this(name, value == null ? null : value.toString());
    }

    public void deepCopy(NameValuePair dto) {
        dto.setName(this.name);
        dto.setValue(this.value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "Name:" + this.name + ", Value:" + this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (EqualsUtil.safeCompareRefs(obj, this)) {
            return true;
        }
        if (obj instanceof NameValuePair) {
            NameValuePair nvp = (NameValuePair)obj;
            boolean equalsSoFar = this.getName() == null ? nvp.getName() == null : this.getName().equals(nvp.getName());
            if (!equalsSoFar) {
                return false;
            }
            if (this.getValue() == null) {
                return nvp.getValue() == null;
            }
            return this.getValue().equals(nvp.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return result;
    }

    public void truncateTo(int maxNumberChars) {
        if (maxNumberChars < 0) {
            throw new IllegalStateException("invalid max number chars: " + maxNumberChars);
        }
        this.truncateTo(maxNumberChars, maxNumberChars);
    }

    public void truncateTo(int maxNameChars, int maxValueChars) {
        String tmpValue;
        if (maxNameChars < 0) {
            throw new IllegalStateException("invalid max name chars: " + maxNameChars);
        }
        if (maxValueChars < 0) {
            throw new IllegalStateException("invalid max value chars: " + maxValueChars);
        }
        String tmpName = this.name;
        if (tmpName != null && tmpName.length() > maxNameChars) {
            this.name = tmpName.substring(0, maxNameChars);
        }
        if ((tmpValue = this.value) != null && tmpValue.length() > maxValueChars) {
            this.value = tmpValue.substring(0, maxValueChars);
        }
    }

    public static Map<String, String> convertNameValuePairsToMap(NameValuePair[] nameValues) {
        HashMap<String, String> nameValuePairs = new HashMap<String, String>();
        if (nameValues != null) {
            for (NameValuePair nameValue : nameValues) {
                nameValuePairs.put(nameValue.getName(), nameValue.getValue());
            }
        }
        return nameValuePairs;
    }

    public static Map<String, String> convertNameValuePairsToOrderedMap(NameValuePair[] nameValues) {
        LinkedHashMap<String, String> nameValuePairs = new LinkedHashMap<String, String>();
        if (nameValues != null) {
            for (NameValuePair nameValue : nameValues) {
                if (nameValue == null) continue;
                nameValuePairs.put(nameValue.getName(), nameValue.getValue());
            }
        }
        return nameValuePairs;
    }

    public static NameValuePair[] convertMap(Map<String, String> nameValueMap) {
        if (nameValueMap == null || nameValueMap.size() == 0) {
            return EMPTY_NAME_VALUE_PAIR_ARRAY;
        }
        NameValuePair[] nameValues = new NameValuePair[nameValueMap.size()];
        int inx = 0;
        for (String key : nameValueMap.keySet()) {
            nameValues[inx] = new NameValuePair(key, nameValueMap.get(key));
            ++inx;
        }
        return nameValues;
    }

    public static NameValuePair[] convertMapToOrderedNameValuePairs(Map<String, String> nameValueMap) {
        if (nameValueMap == null || nameValueMap.isEmpty()) {
            return EMPTY_NAME_VALUE_PAIR_ARRAY;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(nameValueMap);
        return NameValuePair.convertMap(sortedMap);
    }

    public static NameValuePair[] orderNameValuePairs(NameValuePair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return EMPTY_NAME_VALUE_PAIR_ARRAY;
        }
        TreeMap<String, NameValuePair> sortedMap = new TreeMap<String, NameValuePair>();
        for (NameValuePair pair : pairs) {
            if (pair.getName() == null) {
                throw new IllegalArgumentException("name value pair cannot have a null name");
            }
            sortedMap.put(pair.getName(), pair);
        }
        return CollectionHelper.collectionToArray(sortedMap.values(), new NameValuePair[sortedMap.size()]);
    }

    public static NameValuePair[] convertListToOrderedNameValuePairs(List<String> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_NAME_VALUE_PAIR_ARRAY;
        }
        if (list.size() == 1) {
            String name = list.get(0);
            if (name == null) {
                throw new IllegalArgumentException("name value pair cannot have a null name");
            }
            return new NameValuePair[]{new NameValuePair(name, null)};
        }
        ArrayList<String> copy = new ArrayList<String>(list);
        CollectionHelper.sort(copy);
        NameValuePair[] nameValuePairs = new NameValuePair[copy.size()];
        for (int i = 0; i < nameValuePairs.length; ++i) {
            String name = copy.get(i);
            if (name == null) {
                throw new IllegalArgumentException("name value pair cannot have a null name");
            }
            nameValuePairs[i] = new NameValuePair(name, null);
        }
        return nameValuePairs;
    }

    public static NameValuePair getByName(NameValuePair[] pairs, String name) {
        if (pairs == null) {
            return null;
        }
        for (NameValuePair pair : pairs) {
            if (!pair.getName().equals(name)) continue;
            return pair;
        }
        return null;
    }

    public static String convertNVPToCSV(NameValuePair[] pairs) {
        if (pairs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pairs.length; ++i) {
            NameValuePair pair = pairs[i];
            sb.append(pair.getName()).append("=").append(pair.getValue());
            if (i == pairs.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String safeGetValueByName(NameValuePair[] pairs, String name) {
        NameValuePair pair = NameValuePair.getByName(pairs, name);
        return pair == null ? null : pair.getValue();
    }

    public static NameValuePair[] expandArray(NameValuePair[] originalArray, NameValuePair ... addedPairs) {
        if (originalArray == null) {
            return addedPairs == null ? EMPTY_NAME_VALUE_PAIR_ARRAY : addedPairs;
        }
        if (addedPairs == null || addedPairs.length == 0) {
            return originalArray;
        }
        if (originalArray.length == 0) {
            return addedPairs;
        }
        NameValuePair[] returnArray = new NameValuePair[originalArray.length + addedPairs.length];
        System.arraycopy(originalArray, 0, returnArray, 0, originalArray.length);
        System.arraycopy(addedPairs, 0, returnArray, originalArray.length, addedPairs.length);
        return returnArray;
    }

    public static NameValuePair[] expandArray(NameValuePair[] originalArray, Collection<NameValuePair> listOfPairsToAdd) {
        NameValuePair[] returnArray = originalArray;
        if (listOfPairsToAdd != null && listOfPairsToAdd.size() > 0) {
            if (returnArray == null) {
                returnArray = CollectionHelper.collectionToArray(listOfPairsToAdd, new NameValuePair[listOfPairsToAdd.size()]);
            } else {
                returnArray = new NameValuePair[originalArray.length + listOfPairsToAdd.size()];
                System.arraycopy(originalArray, 0, returnArray, 0, originalArray.length);
                int idx = originalArray.length;
                for (NameValuePair nextPair : listOfPairsToAdd) {
                    returnArray[idx++] = nextPair;
                }
            }
        }
        return returnArray;
    }
}

