/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.util.collections.EqualsUtilHelper;
import com.singularity.ee.util.math.DoubleUtils;
import java.io.Serializable;

@UiCodeGen
@TSCodeGen(exclude=true)
public class MetricValue
implements Serializable {
    public static final String NO_VALUE_STRING = "--";
    private static final long serialVersionUID = 1L;
    private long value;
    private long min;
    private long max;
    private long current;
    private long sum;
    private long count;
    private boolean useRange;
    private long groupCount;
    private double standardDeviation;
    private int occurances;

    public MetricValue() {
    }

    public MetricValue(long value, long min, long max, boolean useRange) {
        this(value, min, max, useRange, 0.0);
    }

    public MetricValue(long value) {
        this(value, 0L, 0L, false, 0.0);
    }

    public MetricValue(long value, long count) {
        this.value = value;
        this.count = count;
    }

    public MetricValue(long value, long min, long max, boolean useRange, double standardDeviation) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.useRange = useRange;
        this.standardDeviation = standardDeviation;
    }

    public MetricValue(long value, long min, long max, long current, long sum, long count) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.current = current;
        this.sum = sum;
        this.count = count;
        this.useRange = true;
    }

    public MetricValue(MetricValue metricValue) {
        this.count = metricValue.count;
        this.current = metricValue.current;
        this.max = metricValue.max;
        this.min = metricValue.min;
        this.occurances = metricValue.occurances;
        this.standardDeviation = metricValue.standardDeviation;
        this.sum = metricValue.sum;
        this.useRange = metricValue.useRange;
        this.value = metricValue.value;
        this.groupCount = metricValue.groupCount;
    }

    public MetricValue(long value, long min, long max, long current, long sum, long count, int occurances, double standardDeviation, boolean useRange, long groupCount) {
        this.count = count;
        this.current = current;
        this.max = max;
        this.min = min;
        this.occurances = occurances;
        this.standardDeviation = standardDeviation;
        this.sum = sum;
        this.useRange = useRange;
        this.value = value;
        this.groupCount = groupCount;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public long getSum() {
        return this.sum;
    }

    public void setSum(long sum) {
        this.sum = sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(long groupCount) {
        this.groupCount = groupCount;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public boolean isUseRange() {
        return this.useRange;
    }

    public void setUseRange(boolean useRange) {
        this.useRange = useRange;
    }

    public String toString() {
        return "Value:" + this.value + ", Min:" + this.min + ", Max:" + this.max + ", Sum:" + this.sum + ", Count:" + this.count + ", Stddev: " + this.getStandardDeviation() + ", Occurances: " + this.getOccurances() + ", UseRange: " + this.useRange;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public int getOccurances() {
        return this.occurances;
    }

    public void setOccurances(int occurances) {
        this.occurances = occurances;
    }

    public MetricValue copy() {
        return new MetricValue(this);
    }

    public long getTypedValue(FunctionType functionType) {
        if (functionType == null) {
            return this.getValue();
        }
        switch (functionType) {
            case CURRENT: {
                return this.getCurrent();
            }
            case SUM: {
                return this.getSum();
            }
            case COUNT: {
                return this.getCount();
            }
            case GROUP_COUNT: {
                return this.getGroupCount();
            }
            case MIN: {
                return this.getMin();
            }
            case MAX: {
                return this.getMax();
            }
        }
        return this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetricValue)) {
            return false;
        }
        MetricValue metricValue = (MetricValue)obj;
        return this.value == metricValue.value && this.min == metricValue.min && this.max == metricValue.max && this.current == metricValue.current && this.sum == metricValue.sum && this.count == metricValue.count && this.useRange == metricValue.useRange && EqualsUtilHelper.doubleEquals(this.standardDeviation, metricValue.standardDeviation) && this.occurances == metricValue.occurances && this.groupCount == metricValue.groupCount;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.current ^ this.current >>> 32);
        result = 31 * result + (int)(this.sum ^ this.sum >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (this.useRange ? 1 : 0);
        result = 31 * result + (int)(this.groupCount ^ this.groupCount >>> 32);
        long temp = DoubleUtils.doubleToLongBits(this.standardDeviation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.occurances;
        return result;
    }
}

