/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.MetricDataFrequency;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.MetricValue;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@UiCodeGen
@TSCodeGen(exclude=true)
public class MetricData
implements SingularitySerializable,
Comparable<MetricData> {
    public static final String METRIC_DATA_NOT_FOUND = "METRIC DATA NOT FOUND";
    private static final long serialVersionUID = 1L;
    public static final MetricData[] EMPTY = new MetricData[0];
    private static final MetricDataTimeslice[] EMPTY_METRIC_DATA_TIMESLICE = new MetricDataTimeslice[0];
    private long metricId;
    private String metricName;
    private MetricDataFrequency frequency;
    private long granularityMinutes;
    private MetricDataTimeslice[] dataTimeslices;

    public MetricData() {
    }

    public MetricData(long metricId) {
        this.metricId = metricId;
    }

    @Deprecated
    public MetricData(long metricId, String metricName, MetricDataFrequency frequency) {
        this.metricId = metricId;
        this.metricName = metricName;
        this.frequency = frequency;
        if (frequency == null) {
            this.granularityMinutes = 0L;
        } else {
            switch (frequency) {
                case NO_DATA: {
                    this.granularityMinutes = 0L;
                    break;
                }
                case ONE_MIN: {
                    this.granularityMinutes = 1L;
                    break;
                }
                case TEN_MIN: {
                    this.granularityMinutes = 10L;
                    break;
                }
                case SIXTY_MIN: {
                    this.granularityMinutes = 60L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Frequency " + (Object)((Object)frequency) + " is not valid in this constructor!");
                }
            }
        }
    }

    public MetricData(long metricId, String metricName, long granularityMinutes) {
        this.metricId = metricId;
        this.metricName = metricName;
        this.granularityMinutes = granularityMinutes;
        this.frequency = MetricDataFrequency.fromMinutes((int)granularityMinutes);
    }

    public static MetricData createEmptyMetricData(long metricId, MetricDataFrequency freq) {
        MetricData metricData = new MetricData(metricId, METRIC_DATA_NOT_FOUND, freq);
        metricData.setDataTimeslices(new MetricDataTimeslice[0]);
        return metricData;
    }

    public static MetricData createEmptyMetricData(long metricId, long granularityMinutes) {
        MetricData metricData = new MetricData(metricId, METRIC_DATA_NOT_FOUND, granularityMinutes);
        metricData.setDataTimeslices(new MetricDataTimeslice[0]);
        return metricData;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public static MetricData createEmptyMetricData() {
        MetricData data = new MetricData();
        data.metricId = -1L;
        data.frequency = MetricDataFrequency.ONE_MIN;
        data.dataTimeslices = new MetricDataTimeslice[0];
        data.metricName = "";
        return data;
    }

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public MetricDataFrequency getFrequency() {
        return this.frequency;
    }

    @Deprecated
    public void setFrequency(MetricDataFrequency frequency) {
        this.frequency = frequency;
    }

    public long getGranularityMinutes() {
        return this.granularityMinutes;
    }

    public void setGranularityMinutes(long granularityMinutes) {
        this.granularityMinutes = granularityMinutes;
        this.frequency = MetricDataFrequency.fromMinutes((int)granularityMinutes);
    }

    public MetricDataTimeslice[] getDataTimeslices() {
        return this.dataTimeslices;
    }

    public void setDataTimeslices(MetricDataTimeslice ... slices) {
        this.dataTimeslices = slices;
    }

    public long getLatestTimesliceData() {
        if (this.dataTimeslices != null) {
            for (int i = this.dataTimeslices.length - 1; i >= 0; --i) {
                MetricValue metricValue;
                if (this.dataTimeslices[i] == null || (metricValue = this.dataTimeslices[i].getMetricValue()) == null) continue;
                return metricValue.getValue();
            }
        }
        return -1L;
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "MetricData ( " + super.toString() + "    " + "metricId = " + this.metricId + "    " + "frequency = " + (Object)((Object)this.frequency) + "    " + "granularityMinutes = " + this.granularityMinutes + "    " + "dataTimeslices = " + ArrayUtilsHelper.arrayOfCustomObjectsToString(this.dataTimeslices) + "    " + "metricName = " + this.metricName + "    " + " )";
        return retValue;
    }

    public static MetricData getEmptyMetricData() {
        MetricData data = new MetricData();
        data.setDataTimeslices(EMPTY_METRIC_DATA_TIMESLICE);
        return data;
    }

    public static MetricValue getSafeMetricValueForTimeslice(MetricData data) {
        MetricValue value = MetricData.getMetricValueForFirstTimeslice(data);
        return value == null ? new MetricValue(0L) : value;
    }

    public static long getMetricValueForFirstTimeslice(MetricData data, boolean defaultToZero) {
        MetricValue value = MetricData.getMetricValueForFirstTimeslice(data);
        return value == null ? (defaultToZero ? 0L : -1L) : value.getValue();
    }

    public static MetricValue getMetricValueForFirstTimeslice(MetricData data) {
        if (data == null) {
            return null;
        }
        MetricDataTimeslice[] dataTimeslices = data.getDataTimeslices();
        if (dataTimeslices == null || dataTimeslices.length == 0) {
            return null;
        }
        return dataTimeslices[0].getMetricValue();
    }

    public static Map<Long, MetricData> convertArrayToMap(MetricData[] metricDatas) {
        HashMap<Long, MetricData> rv = new HashMap<Long, MetricData>();
        for (MetricData metricData : metricDatas) {
            if (metricData == null) continue;
            rv.put(metricData.getMetricId(), metricData);
        }
        return rv;
    }

    public float getSumFromMetricDataTimeslicesAfterSpecificTime(long startTime) {
        if (this.getDataTimeslices() == null) {
            return 0.0f;
        }
        Date startTimeDate = new Date(startTime);
        MetricDataTimeslice[] timeSlices = this.getDataTimeslices();
        boolean foundIndexToStartCoutingFrom = false;
        float sumOfPoints = 0.0f;
        for (int i = 0; i < timeSlices.length; ++i) {
            MetricDataTimeslice metricDataTimeslice = timeSlices[i];
            if (metricDataTimeslice.getStartTime() != null && metricDataTimeslice.getStartTime().compareTo(startTimeDate) >= 0) {
                foundIndexToStartCoutingFrom = true;
            }
            if (!foundIndexToStartCoutingFrom || metricDataTimeslice.getMetricValue() == null) continue;
            sumOfPoints += (float)metricDataTimeslice.getMetricValue().getSum();
        }
        return sumOfPoints;
    }

    @Override
    public int compareTo(MetricData o) {
        return (int)(this.metricId - o.metricId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricData)) {
            return false;
        }
        MetricData that = (MetricData)o;
        if (this.metricId != that.metricId) {
            return false;
        }
        if (!CollectionHelper.arrayEquals(this.dataTimeslices, that.dataTimeslices)) {
            return false;
        }
        if (this.granularityMinutes != that.granularityMinutes) {
            return false;
        }
        return !(this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null);
    }

    public int hashCode() {
        int result = (int)(this.metricId ^ this.metricId >>> 32);
        result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
        result = 31 * result + (int)this.granularityMinutes;
        result = 31 * result + (this.dataTimeslices != null ? CollectionHelper.getJavaAlgorithmArrayHashCode(this.dataTimeslices) : 0);
        return result;
    }
}

