/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.TagSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagConstants {
    public static final Long DEFAULT_APPLICATION_ID = 0L;
    public static final Long DEFAULT_ENTITY_ID = 0L;
    public static final String NULL_TAG_VALUE = "NO_TAGS";
    public static final int KEY_MAX_LENGTH = 255;
    public static final int VALUE_MAX_LENGTH = 255;
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final int TAG_ACCESS_LIMIT = 15;
    public static final String ENVIRONMENT_TAGS_KEY = "APPDYNAMICS_ENTITY_TAG_";
    public static final List<EntityType> TAG_SUPPORTED_ENTITY_TYPES = Arrays.asList(EntityType.APPLICATION, EntityType.APPLICATION_COMPONENT, EntityType.APPLICATION_COMPONENT_NODE, EntityType.SIM_MACHINE, EntityType.SYNTH_JOB_REF, EntityType.BASE_PAGE, EntityType.VIRTUAL_PAGE, EntityType.BUSINESS_TRANSACTION, EntityType.DASHBOARD, EntityType.DASHBOARD_V4, EntityType.AGENT_INSTALLATION);
    public static final String SIM_CLUSTER_ENTITY_TABLE_NAME = "sim_machine";
    public static final String APPLICATION_ENTITY_TABLE_NAME = "application";
    public static final String APPLICATION_COMPONENT_ENTITY_TABLE_NAME = "application_component";
    public static final String APPLICATION_COMPONENT_NODE_ENTITY_TABLE_NAME = "application_component_node";
    public static final String BUSINESS_TRANSACTION_ENTITY_TABLE_NAME = "business_transaction";
    public static final String DASHBOARD_ENTITY_TABLE_NAME = "dashboard";
    public static final String DASHBOARD_V4_ENTITY_TABLE_NAME = "custom_dashboard_v4";
    public static final List<EntityType> TAG_SUPPORTED_ENTITY_TYPES_SKIP_CONTEXT = Arrays.asList(EntityType.SIM_MACHINE, EntityType.DASHBOARD, EntityType.DASHBOARD_V4);
    public static final List<EntityType> TAG_SUPPORTED_ENTITY_TYPES_FOR_APP_CONTEXT = Arrays.asList(EntityType.APPLICATION_COMPONENT, EntityType.APPLICATION_COMPONENT_NODE, EntityType.SIM_MACHINE, EntityType.SYNTH_JOB_REF, EntityType.BASE_PAGE, EntityType.VIRTUAL_PAGE, EntityType.BUSINESS_TRANSACTION);
    public static final List<String> TAG_SOURCES_INTERNAL = Arrays.asList("AGENT", "UI");
    public static final Set<String> TAG_SOURCES;
    public static final Set<String> TAG_SOURCES_EXTERNAL;

    static {
        HashSet<String> sourceSet = new HashSet<String>();
        HashSet<String> sourceSetExternal = new HashSet<String>();
        for (TagSource tagSource : TagSource.values()) {
            sourceSet.add(tagSource.name());
            if (TAG_SOURCES_INTERNAL.contains(tagSource.name())) continue;
            sourceSetExternal.add(tagSource.name());
        }
        TAG_SOURCES = Collections.unmodifiableSet(sourceSet);
        TAG_SOURCES_EXTERNAL = Collections.unmodifiableSet(sourceSetExternal);
    }
}

