/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.constants.Severity;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TSCodeGen(exclude=true)
public class NotificationSeverityHelper {
    private static final Map<NotificationSeverity, NotificationSeverityHelper> nSevs;
    private final String imageName;
    private final Severity severity;

    NotificationSeverityHelper(String imageName, Severity severity) {
        this.imageName = imageName;
        this.severity = severity;
    }

    public static Severity toSeverity(NotificationSeverity notificationSeverity) {
        return NotificationSeverityHelper.nSevs.get((Object)((Object)notificationSeverity)).severity;
    }

    public static String getImageName(NotificationSeverity notificationSeverity) {
        NotificationSeverityHelper helper = nSevs.get((Object)notificationSeverity);
        if (helper != null) {
            return helper.imageName;
        }
        return null;
    }

    public static Set<String> getImageNames() {
        HashSet<String> imageNames = new HashSet<String>();
        for (NotificationSeverityHelper helper : nSevs.values()) {
            imageNames.add(helper.imageName);
        }
        return imageNames;
    }

    static {
        HashMap<NotificationSeverity, NotificationSeverityHelper> tmpMap = new HashMap<NotificationSeverity, NotificationSeverityHelper>();
        tmpMap.put(NotificationSeverity.INFO, new NotificationSeverityHelper("PI_INFO_small", Severity.INFO));
        tmpMap.put(NotificationSeverity.WARN, new NotificationSeverityHelper("PI_WARNING_small", Severity.WARNING));
        tmpMap.put(NotificationSeverity.ERROR, new NotificationSeverityHelper("PI_CRITICAL_small", Severity.CRITICAL));
        nSevs = CollectionHelper.unmodifiableMap(tmpMap);
    }
}

