/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.brumuiconfig;

import com.appdynamics.ui.eum.browser.dto.BrowserSessionReplayAgentConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.singularity.ee.controller.api.brumuiconfig.JSAgentVirtualPageRule;
import com.singularity.ee.controller.api.brumuiconfig.JSAgentXhrRule;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JSAgentCodeSnippetBuilder {
    private static final String RELATIVE_PROTOCOL = "//";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String ADRUM_JS = "/adrum/adrum.js";
    private boolean isAutoInjectionSnippet;
    private String autoInjectionTemplate;
    private String adrumVersionJs;
    private int hostOption;
    private boolean useRelativeUrl;
    private String adrumExtUrlHttp;
    private String adrumExtUrlHttps;
    private boolean useHTTPSByDefault;
    private boolean hideUrlQueryString;
    private boolean useStrictDomainCookies;
    private boolean sendImageBeacon;
    private boolean enableXd;
    private boolean enableConfigureResTiming;
    private String sampler;
    private Integer maxNum;
    private Integer bufSize;
    private boolean clearResTimingOnBeaconSend;
    private boolean enableConfigureGeo;
    private String localIP;
    private boolean enableCityRegionCountry;
    private String city;
    private String region;
    private String country;
    private boolean enableGeoResolverUrl;
    private String geoResolverUrlHttp;
    private String geoResolverUrlHttps;
    private boolean enableConfigureUrlLength;
    private Integer maxResUrlSegmentLength;
    private Integer maxResUrlSegmentNumber;
    private Integer maxUrlLength;
    private boolean captureTitle;
    private String customPageTitleV2;
    private boolean setCustomPageName;
    private String customPageName;
    private boolean enableSpa2;
    private boolean clearResTimingSpa2;
    private boolean enableFilterVirtualPages;
    private List<JSAgentVirtualPageRule> virtualPageExcludeRules;
    private boolean enableMonitorFetch;
    private boolean isZoneOrAngular;
    private boolean setAjaxRequestLimit;
    private Integer maxPerPageView;
    private boolean unlimitedPerPageView;
    private boolean filterXhrs;
    private List<JSAgentXhrRule> xhrIncludeRules;
    private List<JSAgentXhrRule> xhrExcludeRules;
    private boolean enableCustomConfig;
    private String customConfig;
    private String releaseId;
    private boolean longStackTrace;
    private boolean enableCoreWebVitals;
    private boolean enableSpeedIndex;
    private BrowserSessionReplayAgentConfig browserSessionReplayAgentConfig;
    private String appKey;
    private String eumJsAgentCdnHostHttp;
    private String eumJsAgentCdnHostHttps;
    private String eumBeaconHostNameHttp;
    private String eumBeaconHostNameHttps;
    private String eumPublicCloudHostHttps;

    public void init(String appKey, String eumJsAgentCdnHostHttp, String eumJsAgentCdnHostHttps, String eumBeaconHostNameHttp, String eumBeaconHostNameHttps, boolean isAutoInjectionSnippet, String autoInjectionTemplate) {
        this.appKey = appKey;
        this.eumJsAgentCdnHostHttp = eumJsAgentCdnHostHttp;
        this.eumJsAgentCdnHostHttps = eumJsAgentCdnHostHttps;
        this.eumBeaconHostNameHttp = eumBeaconHostNameHttp;
        this.eumBeaconHostNameHttps = eumBeaconHostNameHttps;
        this.isAutoInjectionSnippet = isAutoInjectionSnippet;
        this.autoInjectionTemplate = autoInjectionTemplate;
    }

    public JSAgentCodeSnippetBuilder withAdrumVersionJs(String adrumVersionJs) {
        this.adrumVersionJs = adrumVersionJs;
        return this;
    }

    public JSAgentCodeSnippetBuilder withHostOption(int hostOption) {
        this.hostOption = hostOption;
        return this;
    }

    public JSAgentCodeSnippetBuilder withUseRelativeUrl(boolean useRelativeUrl) {
        this.useRelativeUrl = useRelativeUrl;
        return this;
    }

    public JSAgentCodeSnippetBuilder withAdrumExtUrlHttp(String adrumExtUrlHttp) {
        this.adrumExtUrlHttp = adrumExtUrlHttp;
        return this;
    }

    public JSAgentCodeSnippetBuilder withAdrumExtUrlHttps(String adrumExtUrlHttps) {
        this.adrumExtUrlHttps = adrumExtUrlHttps;
        return this;
    }

    public JSAgentCodeSnippetBuilder withUseHTTPSByDefault(boolean useHTTPSByDefault) {
        this.useHTTPSByDefault = useHTTPSByDefault;
        return this;
    }

    public JSAgentCodeSnippetBuilder withHideUrlQueryString(boolean hideUrlQueryString) {
        this.hideUrlQueryString = hideUrlQueryString;
        return this;
    }

    public JSAgentCodeSnippetBuilder withUseStrictDomainCookies(boolean useStrictDomainCookies) {
        this.useStrictDomainCookies = useStrictDomainCookies;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSendImageBeacon(boolean sendImageBeacon) {
        this.sendImageBeacon = sendImageBeacon;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableXd(boolean enableXd) {
        this.enableXd = enableXd;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableConfigureResTiming(boolean enableConfigureResTiming) {
        this.enableConfigureResTiming = enableConfigureResTiming;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSampler(String sampler) {
        this.sampler = sampler;
        return this;
    }

    public JSAgentCodeSnippetBuilder withMaxNum(Integer maxNum) {
        this.maxNum = maxNum;
        return this;
    }

    public JSAgentCodeSnippetBuilder withBufSize(Integer bufSize) {
        this.bufSize = bufSize;
        return this;
    }

    public JSAgentCodeSnippetBuilder withClearResTimingOnBeaconSend(boolean clearResTimingOnBeaconSend) {
        this.clearResTimingOnBeaconSend = clearResTimingOnBeaconSend;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableConfigureGeo(boolean enableConfigureGeo) {
        this.enableConfigureGeo = enableConfigureGeo;
        return this;
    }

    public JSAgentCodeSnippetBuilder withLocalIP(String localIP) {
        this.localIP = localIP;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableCityRegionCountry(boolean enableCityRegionCountry) {
        this.enableCityRegionCountry = enableCityRegionCountry;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCity(String city) {
        this.city = city;
        return this;
    }

    public JSAgentCodeSnippetBuilder withRegion(String region) {
        this.region = region;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCountry(String country) {
        this.country = country;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableGeoResolverUrl(boolean enableGeoResolverUrl) {
        this.enableGeoResolverUrl = enableGeoResolverUrl;
        return this;
    }

    public JSAgentCodeSnippetBuilder withGeoResolverUrlHttp(String geoResolverUrlHttp) {
        this.geoResolverUrlHttp = geoResolverUrlHttp;
        return this;
    }

    public JSAgentCodeSnippetBuilder withGeoResolverUrlHttps(String geoResolverUrlHttps) {
        this.geoResolverUrlHttps = geoResolverUrlHttps;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableConfigureUrlLength(boolean enableConfigureUrlLength) {
        this.enableConfigureUrlLength = enableConfigureUrlLength;
        return this;
    }

    public JSAgentCodeSnippetBuilder withMaxResUrlSegmentLength(Integer maxResUrlSegmentLength) {
        this.maxResUrlSegmentLength = maxResUrlSegmentLength;
        return this;
    }

    public JSAgentCodeSnippetBuilder withMaxResUrlSegmentNumber(Integer maxResUrlSegmentNumber) {
        this.maxResUrlSegmentNumber = maxResUrlSegmentNumber;
        return this;
    }

    public JSAgentCodeSnippetBuilder withMaxUrlLength(Integer maxUrlLength) {
        this.maxUrlLength = maxUrlLength;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCaptureTitle(boolean captureTitle) {
        this.captureTitle = captureTitle;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCustomPageTitleV2(String customPageTitleV2) {
        this.customPageTitleV2 = customPageTitleV2;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSetCustomPageName(boolean setCustomPageName) {
        this.setCustomPageName = setCustomPageName;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCustomPageName(String customPageName) {
        this.customPageName = customPageName;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableSpa2(boolean enableSpa2) {
        this.enableSpa2 = enableSpa2;
        return this;
    }

    public JSAgentCodeSnippetBuilder withClearResTimingSpa2(boolean clearResTimingSpa2) {
        this.clearResTimingSpa2 = clearResTimingSpa2;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableFilterVirtualPages(boolean enableFilterVirtualPages) {
        this.enableFilterVirtualPages = enableFilterVirtualPages;
        return this;
    }

    public JSAgentCodeSnippetBuilder withVirtualPageExcludeRules(List<JSAgentVirtualPageRule> virtualPageExcludeRules) {
        this.virtualPageExcludeRules = virtualPageExcludeRules;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableMonitorFetch(boolean enableMonitorFetch) {
        this.enableMonitorFetch = enableMonitorFetch;
        return this;
    }

    public JSAgentCodeSnippetBuilder withIsZoneOrAngular(boolean isZoneOrAngular) {
        this.isZoneOrAngular = isZoneOrAngular;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSetAjaxRequestLimit(boolean setAjaxRequestLimit) {
        this.setAjaxRequestLimit = setAjaxRequestLimit;
        return this;
    }

    public JSAgentCodeSnippetBuilder withMaxPerPageView(Integer maxPerPageView) {
        this.maxPerPageView = maxPerPageView;
        return this;
    }

    public JSAgentCodeSnippetBuilder withUnlimitedPerPageView(boolean unlimitedPerPageView) {
        this.unlimitedPerPageView = unlimitedPerPageView;
        return this;
    }

    public JSAgentCodeSnippetBuilder withFilterXhrs(boolean filterXhrs) {
        this.filterXhrs = filterXhrs;
        return this;
    }

    public JSAgentCodeSnippetBuilder withXhrIncludeRules(List<JSAgentXhrRule> xhrIncludeRules) {
        this.xhrIncludeRules = xhrIncludeRules;
        return this;
    }

    public JSAgentCodeSnippetBuilder withXhrExcludeRules(List<JSAgentXhrRule> xhrExcludeRules) {
        this.xhrExcludeRules = xhrExcludeRules;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEnableCustomConfig(boolean enableCustomConfig) {
        this.enableCustomConfig = enableCustomConfig;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCustomConfig(String customConfig) {
        this.customConfig = customConfig;
        return this;
    }

    public JSAgentCodeSnippetBuilder withReleaseId(String releaseId) {
        this.releaseId = releaseId;
        return this;
    }

    public JSAgentCodeSnippetBuilder withLongStackTrace(boolean longStackTrace) {
        this.longStackTrace = longStackTrace;
        return this;
    }

    public JSAgentCodeSnippetBuilder withCoreWebVitals(boolean enableCoreWebVitals) {
        this.enableCoreWebVitals = enableCoreWebVitals;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSpeedIndex(boolean enableSpeedIndex) {
        this.enableSpeedIndex = enableSpeedIndex;
        return this;
    }

    public JSAgentCodeSnippetBuilder withSessionReplayConfig(BrowserSessionReplayAgentConfig browserSessionReplayAgentConfig) {
        this.browserSessionReplayAgentConfig = browserSessionReplayAgentConfig;
        return this;
    }

    public JSAgentCodeSnippetBuilder withEumPublicCloudHost(String eumPublicCloudHost) {
        this.eumPublicCloudHostHttps = eumPublicCloudHost;
        return this;
    }

    public String buildConfigSnippet() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildStandardAndAdvancedConfigSnippet());
        if (this.enableCustomConfig) {
            sb.append(this.buildCustomConfigSnippet());
        }
        sb.append(this.buildAdrumScriptIncludeSnippet());
        return sb.toString();
    }

    private String buildBrowserSessionReplayConfigSnippet() {
        StringBuilder sb = new StringBuilder();
        if (this.browserSessionReplayAgentConfig != null) {
            JsonObject jsonObject = new JsonObject();
            if (this.browserSessionReplayAgentConfig.enabled != null && this.browserSessionReplayAgentConfig.enabled.booleanValue()) {
                jsonObject.addProperty("enabled", this.browserSessionReplayAgentConfig.enabled);
                jsonObject.addProperty("sessionReplayUrlHttps", this.eumPublicCloudHostHttps);
                sb.append("    config.sessionReplay = ").append(jsonObject).append(";\n");
            }
        }
        return sb.toString();
    }

    private String buildStandardAndAdvancedConfigSnippet() {
        StringBuilder sb = new StringBuilder();
        String extUrlHttp = "";
        String extUrlHttps = "";
        switch (this.hostOption) {
            case 0: {
                extUrlHttp = HTTP + this.eumJsAgentCdnHostHttp;
                extUrlHttps = HTTPS + this.eumJsAgentCdnHostHttps;
                break;
            }
            case 1: {
                extUrlHttp = HTTP + this.adrumExtUrlHttp;
                extUrlHttps = HTTPS + this.adrumExtUrlHttps;
                break;
            }
            case 2: {
                extUrlHttp = HTTP + this.eumJsAgentCdnHostHttp;
                extUrlHttps = HTTPS + this.eumJsAgentCdnHostHttps;
                break;
            }
            default: {
                throw new IllegalStateException("Host option should be an integer in the range [0,2]");
            }
        }
        if (this.isAutoInjectionSnippet) {
            sb.append(";");
        } else {
            sb.append("<script charset=\"UTF-8\" type=\"text/javascript\">\n");
        }
        if (!this.enableCustomConfig) {
            sb.append(this.buildWindowConfigSnippet());
        }
        if (!this.isAutoInjectionSnippet) {
            sb.append("window[\"adrum-start-time\"] = new Date().getTime();\n");
        }
        sb.append("(function(config){").append("\n").append("    config.appKey = \"").append(this.appKey).append("\";").append("\n").append("    config.adrumExtUrlHttp = \"").append(extUrlHttp).append("\";").append("\n").append("    config.adrumExtUrlHttps = \"").append(extUrlHttps).append("\";").append("\n").append("    config.beaconUrlHttp = \"http://").append(this.eumBeaconHostNameHttp).append("\";").append("\n").append("    config.beaconUrlHttps = \"https://").append(this.eumBeaconHostNameHttps).append("\";").append("\n");
        if (this.enableCustomConfig) {
            if (this.enableXd) {
                sb.append("    config.xd = {\"enable\":").append(this.enableXd).append("};").append("\n");
            }
            if (this.enableGeoResolverUrl) {
                if (StringUtils.isNotBlank((CharSequence)this.geoResolverUrlHttp)) {
                    sb.append("    config.geoResolverUrlHttp = \"http://").append(this.geoResolverUrlHttp).append("\";\n");
                }
                if (StringUtils.isNotBlank((CharSequence)this.geoResolverUrlHttps)) {
                    sb.append("    config.geoResolverUrlHttps = \"https://").append(this.geoResolverUrlHttps).append("\";\n");
                }
            }
        }
        if (this.isAutoInjectionSnippet && this.sendImageBeacon) {
            sb.append("    config.beacon = {\"sendImageBeacon\":").append(this.sendImageBeacon).append("};").append("\n");
        }
        sb.append(this.buildBrowserSessionReplayConfigSnippet());
        if (!this.enableCustomConfig) {
            sb.append(this.buildAdvancedConfigSnippet());
        }
        sb.append("})(window[\"adrum-config\"] || (window[\"adrum-config\"] = {}));\n");
        return sb.toString();
    }

    private String buildAdvancedConfigSnippet() {
        JsonArray exclude;
        JsonObject page;
        StringBuilder sb = new StringBuilder();
        if (this.useHTTPSByDefault) {
            sb.append("    config.useHTTPSAlways = ").append(this.useHTTPSByDefault).append(";").append("\n");
        }
        if (this.hideUrlQueryString) {
            sb.append("    config.urlCapture = {\"filterURLQuery\":").append(this.hideUrlQueryString).append("};").append("\n");
        }
        if (this.enableXd) {
            sb.append("    config.xd = {\"enable\":").append(this.enableXd).append("};").append("\n");
        }
        if (this.enableConfigureResTiming) {
            JsonObject sampler = new JsonObject();
            if (StringUtils.isNotBlank((CharSequence)this.sampler)) {
                sampler.addProperty("sampler", this.sampler);
            }
            if (this.maxNum != null) {
                sampler.addProperty("maxNum", (Number)this.maxNum);
            }
            if (this.bufSize != null) {
                sampler.addProperty("bufSize", (Number)this.bufSize);
            }
            if (this.clearResTimingOnBeaconSend) {
                sampler.addProperty("clearResTimingOnBeaconSend", Boolean.valueOf(this.clearResTimingOnBeaconSend));
            }
            sb.append("    config.resTiming = ").append(sampler).append(";\n");
        }
        if (this.enableConfigureGeo) {
            JsonObject geo = new JsonObject();
            if (StringUtils.isNotBlank((CharSequence)this.localIP)) {
                geo.addProperty("localIP", this.localIP);
            }
            if (this.enableCityRegionCountry) {
                if (StringUtils.isNotBlank((CharSequence)this.city)) {
                    geo.addProperty("city", this.city);
                }
                if (StringUtils.isNotBlank((CharSequence)this.region)) {
                    geo.addProperty("region", this.region);
                }
                if (StringUtils.isNotBlank((CharSequence)this.country)) {
                    geo.addProperty("country", this.country);
                }
            }
            sb.append("    config.geo = ").append(geo).append(";\n");
        }
        if (this.enableGeoResolverUrl) {
            if (StringUtils.isNotBlank((CharSequence)this.geoResolverUrlHttp)) {
                sb.append("    config.geoResolverUrlHttp = \"http://").append(this.geoResolverUrlHttp).append("\";\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.geoResolverUrlHttps)) {
                sb.append("    config.geoResolverUrlHttps = \"https://").append(this.geoResolverUrlHttps).append("\";\n");
            }
        }
        if (this.enableConfigureUrlLength) {
            if (this.maxResUrlSegmentLength != null) {
                sb.append("    config.maxResUrlSegmentLength = ").append(this.maxResUrlSegmentLength).append(";\n");
            }
            if (this.maxResUrlSegmentNumber != null) {
                sb.append("    config.maxResUrlSegmentNumber = ").append(this.maxResUrlSegmentNumber).append(";\n");
            }
            if (this.maxUrlLength != null) {
                sb.append("    config.maxUrlLength = ").append(this.maxUrlLength).append(";\n");
            }
        }
        if (!this.captureTitle) {
            page = new JsonObject();
            page.addProperty("captureTitle", Boolean.valueOf(false));
            sb.append("    config.page = ").append(page).append(";\n");
        } else if (StringUtils.isNotBlank((CharSequence)this.customPageTitleV2)) {
            page = new JsonObject();
            page.addProperty("title", this.customPageTitleV2);
            sb.append("    config.page = ").append(page).append(";\n");
        }
        if (this.enableSpa2) {
            if (this.clearResTimingSpa2 || this.enableFilterVirtualPages) {
                JsonObject spa2JsonObject = new JsonObject();
                if (this.enableFilterVirtualPages) {
                    exclude = new JsonArray();
                    for (int i = 0; i < this.virtualPageExcludeRules.size(); ++i) {
                        JSAgentVirtualPageRule jSAgentVirtualPageRule = this.virtualPageExcludeRules.get(i);
                        if (jSAgentVirtualPageRule.getRegexUrls() == null) continue;
                        JsonArray urlArray = new JsonArray();
                        for (int j = 0; j < jSAgentVirtualPageRule.getRegexUrls().length; ++j) {
                            JsonObject pattern = new JsonObject();
                            String regexUrl = jSAgentVirtualPageRule.getRegexUrls()[j];
                            if (!StringUtils.isNotBlank((CharSequence)regexUrl)) continue;
                            pattern.addProperty("pattern", regexUrl);
                            urlArray.add((JsonElement)pattern);
                        }
                        JsonObject rule = new JsonObject();
                        rule.add("urls", (JsonElement)urlArray);
                        exclude.add((JsonElement)rule);
                    }
                    JsonObject vp = new JsonObject();
                    vp.add("exclude", (JsonElement)exclude);
                    spa2JsonObject.add("vp", (JsonElement)vp);
                }
                if (this.clearResTimingSpa2) {
                    spa2JsonObject.addProperty("clearResTiming", Boolean.valueOf(this.clearResTimingSpa2));
                }
                JsonObject spa = new JsonObject();
                spa.add("spa2", (JsonElement)spa2JsonObject);
                sb.append("    config.spa = ").append(spa.toString()).append(";\n");
            } else {
                sb.append("    config.spa = {\"spa2\":").append(this.enableSpa2).append("};\n");
            }
        }
        if (this.setCustomPageName && StringUtils.isNotBlank((CharSequence)this.customPageName)) {
            JsonObject userPageName = new JsonObject();
            userPageName.addProperty("userPageName", this.customPageName);
            sb.append("    (function (info) {\n");
            sb.append("        info.PageView = ").append(userPageName).append(";\n");
            sb.append("    })(config.userEventInfo || (config.userEventInfo = {}));\n");
        }
        if (!this.enableMonitorFetch) {
            sb.append("    config.fetch = ").append(false).append(";\n");
        }
        if (this.isZoneOrAngular) {
            sb.append("    config.isZonePromise = true;\n    config.angular = true;\n");
        }
        if (this.filterXhrs || this.setAjaxRequestLimit) {
            JsonObject xhr = new JsonObject();
            if (this.filterXhrs) {
                String method;
                String regexUrl;
                JsonObject pattern;
                JsonArray urlArray;
                JsonObject rule;
                if (this.xhrIncludeRules != null) {
                    JsonArray include = new JsonArray();
                    for (JSAgentXhrRule jSAgentXhrRule : this.xhrIncludeRules) {
                        rule = new JsonObject();
                        if (jSAgentXhrRule.getRegexUrls() != null) {
                            urlArray = new JsonArray();
                            for (int j = 0; j < jSAgentXhrRule.getRegexUrls().length; ++j) {
                                pattern = new JsonObject();
                                regexUrl = jSAgentXhrRule.getRegexUrls()[j];
                                if (!StringUtils.isNotBlank((CharSequence)regexUrl)) continue;
                                pattern.addProperty("pattern", regexUrl);
                                urlArray.add((JsonElement)pattern);
                            }
                            rule.add("urls", (JsonElement)urlArray);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(method = jSAgentXhrRule.getMethod()))) {
                            rule.addProperty("method", method);
                        }
                        if (rule.isJsonNull()) continue;
                        include.add((JsonElement)rule);
                    }
                    xhr.add("include", (JsonElement)include);
                }
                if (this.xhrExcludeRules != null) {
                    exclude = new JsonArray();
                    for (JSAgentXhrRule jSAgentXhrRule : this.xhrExcludeRules) {
                        rule = new JsonObject();
                        if (jSAgentXhrRule.getRegexUrls() != null) {
                            urlArray = new JsonArray();
                            for (int l = 0; l < jSAgentXhrRule.getRegexUrls().length; ++l) {
                                pattern = new JsonObject();
                                regexUrl = jSAgentXhrRule.getRegexUrls()[l];
                                if (!StringUtils.isNotBlank((CharSequence)regexUrl)) continue;
                                pattern.addProperty("pattern", regexUrl);
                                urlArray.add((JsonElement)pattern);
                            }
                            rule.add("urls", (JsonElement)urlArray);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(method = jSAgentXhrRule.getMethod()))) {
                            rule.addProperty("method", method);
                        }
                        if (rule.isJsonNull()) continue;
                        exclude.add((JsonElement)rule);
                    }
                    xhr.add("exclude", (JsonElement)exclude);
                }
            }
            if (this.setAjaxRequestLimit) {
                if (this.unlimitedPerPageView) {
                    xhr.addProperty("maxPerPageView", "UNLIMITED");
                } else if (this.maxPerPageView != null) {
                    xhr.addProperty("maxPerPageView", (Number)this.maxPerPageView);
                }
            }
            sb.append("    config.xhr = ").append(xhr).append(";\n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.releaseId)) {
            sb.append("    config.releaseId = \"").append(this.releaseId).append("\";\n");
        }
        if (!this.longStackTrace) {
            sb.append("    config.longStackTrace = ").append(false).append(";").append("\n");
        }
        if (this.enableCoreWebVitals) {
            sb.append("    config.enableCoreWebVitals = ").append(true).append(";").append("\n");
        }
        if (this.enableSpeedIndex) {
            sb.append("    config.enableSpeedIndex = ").append(true).append(";").append("\n");
        }
        return sb.toString();
    }

    private String buildCustomConfigSnippet() {
        if (StringUtils.isNotBlank((CharSequence)this.customConfig)) {
            return this.customConfig + "\n";
        }
        return "";
    }

    private String buildWindowConfigSnippet() {
        if (this.useStrictDomainCookies) {
            return "window[\"adrum-use-strict-domain-cookies\"] = " + this.useStrictDomainCookies + ";\n";
        }
        return "";
    }

    private String buildAdrumScriptIncludeSnippet() {
        if (this.isAutoInjectionSnippet && this.hostOption == 0) {
            return this.autoInjectionTemplate;
        }
        String adrumVer = StringUtils.isNotBlank((CharSequence)this.adrumVersionJs) ? this.adrumVersionJs : "/adrum/adrum-latest.js";
        String adrumJsFile = this.hostOption == 0 ? adrumVer : ADRUM_JS;
        String adrumUrlHttp = this.hostOption == 0 ? this.eumJsAgentCdnHostHttp : this.adrumExtUrlHttp;
        String adrumUrlHttps = this.hostOption == 0 ? this.eumJsAgentCdnHostHttps : this.adrumExtUrlHttps;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)adrumUrlHttps) && StringUtils.isNotBlank((CharSequence)adrumUrlHttp)) {
            this.appendScriptIncludeStyleSnippet(sb, adrumUrlHttp, adrumJsFile);
        } else if (StringUtils.isBlank((CharSequence)adrumUrlHttp) && StringUtils.isNotBlank((CharSequence)adrumUrlHttps)) {
            this.appendScriptIncludeStyleSnippet(sb, adrumUrlHttps, adrumJsFile);
        } else if (StringUtils.isNotBlank((CharSequence)adrumUrlHttp) && StringUtils.isNotBlank((CharSequence)adrumUrlHttps) && adrumUrlHttps.equals(adrumUrlHttp)) {
            this.appendScriptIncludeStyleSnippet(sb, adrumUrlHttps, adrumJsFile);
        } else {
            this.appendDocumentWriteStyleSnippet(sb, adrumUrlHttps, adrumUrlHttp, adrumJsFile);
        }
        return sb.toString();
    }

    private void appendScriptIncludeStyleSnippet(StringBuilder sb, String adrumUrl, String adrumJsFile) {
        if (this.isAutoInjectionSnippet) {
            sb.append("</script>").append("\n").append("<script src=\"").append(RELATIVE_PROTOCOL).append(adrumUrl).append(adrumJsFile).append("\">");
        } else {
            sb.append("</script>").append("\n").append("<script src=\"").append(RELATIVE_PROTOCOL).append(adrumUrl).append(adrumJsFile).append("\"></script>");
        }
    }

    private void appendDocumentWriteStyleSnippet(StringBuilder sb, String httpsUrl, String httpUrl, String adrumJsFile) {
        String adrumUrlHttps = HTTPS + httpsUrl + adrumJsFile;
        String adrumUrlHttp = HTTP + httpUrl + adrumJsFile;
        sb.append("\n").append("if ('https:' === document.location.protocol) {").append("\n").append("    document.write(").append("unescape('%3Cscript')\n + ").append("\" src='" + adrumUrlHttps + "' \"\n").append(" + \" type='text/javascript' charset='UTF-8'\" \n + unescape('%3E%3C/script%3E'));\n").append("} else {\n").append("    document.write(").append("unescape('%3Cscript')\n + ").append("\" src='" + adrumUrlHttp + "' \"\n").append(" + \" type='text/javascript' charset='UTF-8'\" \n + unescape('%3E%3C/script%3E'));\n").append("}\n");
        if (!this.isAutoInjectionSnippet) {
            sb.append("</script>\n");
        }
    }
}

