/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.google.common.math.DoubleMath;
import java.math.BigInteger;

public class UnknownValueUtil {
    private static final long UNKNOWN_VALUE = -1L;
    private static final String UNKNOWN_VALUE_STRING = "unknown value";

    private UnknownValueUtil() {
    }

    public static boolean isUnknownValue(long ... values) {
        for (long value : values) {
            if (value != -1L) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnknownValue(String value) {
        return value == null || value.equals(UNKNOWN_VALUE_STRING) || value.equals(String.valueOf(-1L));
    }

    public static boolean isUnknownValue(BigInteger ... values) {
        for (BigInteger value : values) {
            if (value != null && !UnknownValueUtil.isUnknownValue(value.longValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnknownValue(double ... values) {
        for (double value : values) {
            if (!DoubleMath.isMathematicalInteger((double)value) || !UnknownValueUtil.isUnknownValue((long)value)) continue;
            return true;
        }
        return false;
    }

    public static long getUnknownValue() {
        return -1L;
    }

    public static String getUnknownValueStr() {
        return UNKNOWN_VALUE_STRING;
    }

    public static long calculatedValueOrUnknown(long rawValue, long calculatedValue) {
        return UnknownValueUtil.isUnknownValue(rawValue) ? -1L : calculatedValue;
    }

    public static long calculatedValueOrUnknown(long param1, long param2, long calculatedValue) {
        if (UnknownValueUtil.isUnknownValue(param1, param2)) {
            return -1L;
        }
        return calculatedValue;
    }
}

